/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.jbi.messaging.MessageExchange;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.http.endpoints.HttpConsumerMarshaler;

public abstract class AbstractHttpConsumerMarshaler
implements HttpConsumerMarshaler {
    private final Log log = LogFactory.getLog(this.getClass());

    protected InputStream getRequestEncodingStream(String contentEncoding, InputStream dataStream) throws IOException {
        if (contentEncoding != null && contentEncoding.toLowerCase().indexOf("gzip") >= 0) {
            this.log.debug((Object)"Using GZIP request content encoding.");
            return new GZIPInputStream(new BufferedInputStream(dataStream));
        }
        this.log.debug((Object)"Using default request content encoding.");
        return new BufferedInputStream(dataStream);
    }

    protected OutputStream getResponseEncodingStream(String acceptEncoding, OutputStream dataStream) throws IOException {
        if (acceptEncoding != null && acceptEncoding.toLowerCase().indexOf("gzip") >= 0) {
            this.log.debug((Object)"Using GZIP response content encoding.");
            return new GZIPOutputStream(new BufferedOutputStream(dataStream));
        }
        this.log.debug((Object)"Using default response content encoding.");
        return new BufferedOutputStream(dataStream);
    }

    protected void addResponseHeaders(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.toLowerCase().indexOf("gzip") >= 0) {
            response.setHeader("Content-Encoding", "gzip");
        }
    }
}

