/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.packaging;

import java.util.ArrayList;
import java.util.List;
import javax.jbi.messaging.MessageExchange;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.packaging.Consumes;
import org.apache.servicemix.common.xbean.AbstractXBeanServiceUnitAnalyzer;
import org.apache.servicemix.http.HttpEndpoint;

public class HttpServiceUnitAnalyzer
extends AbstractXBeanServiceUnitAnalyzer {
    protected List getConsumes(Endpoint endpoint) {
        ArrayList<Consumes> consumesList = new ArrayList<Consumes>();
        if (endpoint.getRole().equals(MessageExchange.Role.CONSUMER)) {
            Consumes consumes = new Consumes();
            HttpEndpoint httpEndpoint = (HttpEndpoint)endpoint;
            consumes.setEndpointName(httpEndpoint.getTargetEndpoint());
            consumes.setInterfaceName(httpEndpoint.getTargetInterfaceName());
            consumes.setServiceName(httpEndpoint.getTargetService());
            if (consumes.isValid()) {
                consumesList.add(consumes);
            } else {
                consumes = new Consumes();
                consumes.setEndpointName(endpoint.getEndpoint());
                consumes.setInterfaceName(endpoint.getInterfaceName());
                consumes.setServiceName(endpoint.getService());
                consumesList.add(consumes);
            }
        }
        return consumesList;
    }

    protected String getXBeanFile() {
        return "xbean.xml";
    }

    protected boolean isValidEndpoint(Object bean) {
        return bean instanceof HttpEndpoint;
    }
}

