/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    private static final String SYNTAX = "jbi:jbi-jar-uri[,jbi-instr-uri][$jbi-instructions]";
    private static final String INSTRUCTIONS_SEPARATOR = "$";
    private static final String INSTRUCTIONS_FILE_SEPARATOR = ",";
    private static final Pattern SYNTAX_JAR_BND_INSTR = Pattern.compile("(.+?),(.+?)\\$(.+?)");
    private static final Pattern SYNTAX_JAR_INSTR = Pattern.compile("(.+?)\\$(.+?)");
    private static final Pattern SYNTAX_JAR_BND = Pattern.compile("(.+?),(.+?)");
    private static final Pattern INSTRUCTIONS_PATTERN = Pattern.compile("([a-zA-Z_0-9-]+)=([-!\"'()*+,.0-9A-Z_a-z%;=]+)");
    private URL jbiJarURL;
    private Properties jbiProperties;

    public Parser(String path) throws MalformedURLException {
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot be null or empty. Syntax jbi:jbi-jar-uri[,jbi-instr-uri][$jbi-instructions]");
        }
        if (path.startsWith(INSTRUCTIONS_SEPARATOR) || path.endsWith(INSTRUCTIONS_SEPARATOR)) {
            throw new MalformedURLException("Path cannot start or end with $. Syntax jbi:jbi-jar-uri[,jbi-instr-uri][$jbi-instructions]");
        }
        this.jbiProperties = new Properties();
        Matcher matcher = SYNTAX_JAR_BND_INSTR.matcher(path);
        if (matcher.matches()) {
            this.jbiJarURL = new URL(matcher.group(1));
            this.parseInstructionsFile(new URL(matcher.group(2)));
            this.jbiProperties.putAll((Map<?, ?>)Parser.parseInstructions(matcher.group(3)));
        } else {
            matcher = SYNTAX_JAR_INSTR.matcher(path);
            if (matcher.matches()) {
                this.jbiJarURL = new URL(matcher.group(1));
                this.jbiProperties.putAll((Map<?, ?>)Parser.parseInstructions(matcher.group(2)));
            } else {
                matcher = SYNTAX_JAR_BND.matcher(path);
                if (matcher.matches()) {
                    this.jbiJarURL = new URL(matcher.group(1));
                    this.parseInstructionsFile(new URL(matcher.group(2)));
                } else {
                    this.jbiJarURL = new URL(path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInstructionsFile(URL bndFileURL) throws MalformedURLException {
        try {
            InputStream is = null;
            try {
                is = bndFileURL.openStream();
                this.jbiProperties.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            Parser.throwAsMalformedURLException("Could not retrieve the instructions from [" + bndFileURL + "]", e);
        }
    }

    public URL getJbiJarURL() {
        return this.jbiJarURL;
    }

    public Properties getJbiProperties() {
        return this.jbiProperties;
    }

    public static Properties parseInstructions(String query) throws MalformedURLException {
        Properties instructions = new Properties();
        if (query != null) {
            try {
                String[] segments;
                for (String segment : segments = query.split("&")) {
                    if (segment.trim().length() <= 0) continue;
                    Matcher matcher = INSTRUCTIONS_PATTERN.matcher(segment);
                    if (matcher.matches()) {
                        instructions.setProperty(matcher.group(1), URLDecoder.decode(matcher.group(2), "UTF-8"));
                        continue;
                    }
                    throw new MalformedURLException("Invalid syntax for instruction [" + segment + "]. Take a look at http://www.aqute.biz/Code/Bnd.");
                }
            }
            catch (UnsupportedEncodingException e) {
                Parser.throwAsMalformedURLException("Could not retrieve the instructions from [" + query + "]", e);
            }
        }
        return instructions;
    }

    private static void throwAsMalformedURLException(String message, Exception cause) throws MalformedURLException {
        MalformedURLException exception = new MalformedURLException(message);
        exception.initCause(cause);
        throw exception;
    }
}

