/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.util.HashSet;
import javax.jbi.management.AdminServiceMBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.impl.DefaultNamingStrategy;
import org.apache.servicemix.jbi.deployer.impl.Deployer;

public class AdminService
implements AdminServiceMBean {
    public static final String DEFAULT_NAME = "ServiceMix";
    public static final String DEFAULT_DOMAIN = "org.apache.servicemix";
    public static final String DEFAULT_CONNECTOR_PATH = "/jmxrmi";
    public static final int DEFAULT_CONNECTOR_PORT = 1099;
    private Deployer deployer;
    private DefaultNamingStrategy namingStrategy;

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public void setNamingStrategy(DefaultNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public DefaultNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public ObjectName[] getBindingComponents() {
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        for (ComponentImpl component : this.deployer.getComponents().values()) {
            if (!"binding-component".equals(component.getType())) continue;
            try {
                names.add(this.namingStrategy.getObjectName(component));
            }
            catch (MalformedObjectNameException e) {}
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public ObjectName getComponentByName(String name) {
        ComponentImpl component = this.deployer.getComponent(name);
        if (component != null) {
            try {
                return this.namingStrategy.getObjectName(component);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
        }
        return null;
    }

    public ObjectName[] getEngineComponents() {
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        for (ComponentImpl component : this.deployer.getComponents().values()) {
            if (!"service-engine".equals(component.getType())) continue;
            try {
                names.add(this.namingStrategy.getObjectName(component));
            }
            catch (MalformedObjectNameException e) {}
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public String getSystemInfo() {
        return "ServiceMix 4";
    }

    public ObjectName getSystemService(String serviceName) {
        return null;
    }

    public ObjectName[] getSystemServices() {
        return new ObjectName[0];
    }

    public boolean isBinding(String componentName) {
        ComponentImpl component = this.deployer.getComponent(componentName);
        return component != null && "binding-component".equals(component.getType());
    }

    public boolean isEngine(String componentName) {
        ComponentImpl component = this.deployer.getComponent(componentName);
        return component != null && "service-engine".equals(component.getType());
    }
}

