/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.AdminCommandsService;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.NamingStrategy;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.runtime.impl.ManagementContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamingStrategy
implements NamingStrategy {
    private static final Log LOG = LogFactory.getLog(DefaultNamingStrategy.class);
    private String jmxDomainName;

    @Override
    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    @Override
    public ObjectName getObjectName(SharedLibrary sharedLibrary) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Type=SharedLibrary," + "Name=" + this.sanitize(sharedLibrary.getName()) + "," + "Version=" + this.sanitize(sharedLibrary.getVersion()));
    }

    @Override
    public ObjectName getObjectName(Component component) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Type=Component," + "Name=" + this.sanitize(component.getName()) + "," + "SubType=LifeCycle");
    }

    @Override
    public ObjectName getObjectName(ServiceAssembly serviceAssembly) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Type=ServiceAssembly," + "Name=" + this.sanitize(serviceAssembly.getName()));
    }

    @Override
    public ObjectName getObjectName(AdminCommandsService adminCommandsService) throws MalformedObjectNameException {
        return DefaultNamingStrategy.getSystemObjectName(this.jmxDomainName, "ServiceMix", AdminCommandsService.class);
    }

    private String sanitize(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }

    @Override
    public ObjectName createCustomComponentMBeanName(String type, String name) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("Type", "Component");
        result.put("Name", this.sanitize(name));
        result.put("SubType", this.sanitize(type));
        return this.createObjectName(result);
    }

    public ObjectName createObjectName(Map<String, String> props) {
        return ManagementContext.createObjectName((String)this.getJmxDomainName(), props);
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class interfaceType) {
        String tmp = domainName + ":ContainerName=" + containerName + ",Type=SystemService,Name=" + DefaultNamingStrategy.getSystemServiceName(interfaceType);
        ObjectName result = null;
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)"Failed to build ObjectName:", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)"Failed to build ObjectName:", (Throwable)e);
        }
        return result;
    }

    public static String getSystemServiceName(Class interfaceType) {
        String name = interfaceType.getName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).endsWith("MBean")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }
}

