/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.management;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RmiRegistryFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private int port = 1099;
    private Registry registry;
    private boolean locate;
    private boolean create = true;
    private boolean locallyCreated;

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean isLocate() {
        return this.locate;
    }

    public void setLocate(boolean locate) {
        this.locate = locate;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Object getObject() throws Exception {
        return this.registry;
    }

    public Class getObjectType() {
        return Registry.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws RemoteException {
        if (this.registry == null && this.locate) {
            try {
                Registry reg = LocateRegistry.getRegistry(this.getPort());
                reg.list();
                this.registry = reg;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.registry == null && this.create) {
            this.registry = LocateRegistry.createRegistry(this.getPort());
            this.locallyCreated = true;
        }
    }

    public void destroy() throws RemoteException {
        if (this.registry != null && this.locallyCreated) {
            Registry reg = this.registry;
            this.registry = null;
            UnicastRemoteObject.unexportObject(reg, true);
        }
    }
}

