/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorAwareRunnable;
import org.apache.servicemix.nmr.api.AbortedException;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalChannel;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.core.ChannelClosedException;
import org.apache.servicemix.nmr.core.ExchangeImpl;

public class ChannelImpl
implements InternalChannel {
    private static final Log LOG = LogFactory.getLog(NMR.class);
    private final InternalEndpoint endpoint;
    private final Executor executor;
    private final NMR nmr;
    private String name;
    private AtomicBoolean closed = new AtomicBoolean();
    private boolean shouldRunSynchronously;

    public ChannelImpl(InternalEndpoint endpoint, Executor executor, NMR nmr) {
        this.endpoint = endpoint;
        this.executor = executor;
        this.nmr = nmr;
        Map props = nmr.getEndpointRegistry().getProperties((Object)endpoint);
        if (props != null) {
            this.name = (String)props.get("NAME");
        }
        if (this.name == null) {
            this.name = this.toString();
        }
    }

    public boolean isShouldRunSynchronously() {
        return this.shouldRunSynchronously;
    }

    public void setShouldRunSynchronously(boolean shouldRunSynchronously) {
        this.shouldRunSynchronously = shouldRunSynchronously;
    }

    public NMR getNMR() {
        return this.nmr;
    }

    public InternalEndpoint getEndpoint() {
        return this.endpoint;
    }

    public Exchange createExchange(Pattern pattern) {
        return new ExchangeImpl(pattern);
    }

    public void send(Exchange exchange) {
        InternalExchange e = (InternalExchange)exchange;
        this.dispatch(e);
    }

    public boolean sendSync(Exchange exchange) {
        return this.sendSync(exchange, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSync(Exchange exchange, long timeout) {
        InternalExchange e = (InternalExchange)exchange;
        Semaphore lock = e.getRole() == Role.Consumer ? e.getConsumerLock(true) : e.getProviderLock(true);
        this.dispatch(e);
        Thread thread = Thread.currentThread();
        String original = thread.getName();
        try {
            if (timeout > 0L) {
                if (!lock.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException();
                }
            } else {
                thread.setName(original + " (waiting for exchange " + exchange.getId() + ")");
                lock.acquire();
            }
            e.setRole(e.getRole() == Role.Consumer ? Role.Provider : Role.Consumer);
        }
        catch (InterruptedException ex) {
            exchange.setError((Exception)ex);
            for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
                l.exchangeFailed(exchange);
            }
            boolean i$ = false;
            return i$;
        }
        catch (TimeoutException ex) {
            exchange.setError((Exception)new AbortedException((Throwable)ex));
            for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
                l.exchangeFailed(exchange);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            thread.setName(original);
        }
        return true;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Map props = this.nmr.getEndpointRegistry().getProperties((Object)this.endpoint);
            this.nmr.getEndpointRegistry().unregister((Endpoint)this.endpoint, props);
            this.executor.shutdown();
        }
    }

    public void deliver(final InternalExchange exchange) {
        Semaphore lock;
        if (this.closed.get()) {
            throw new ChannelClosedException();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Channel " + this.name + " delivering exchange: " + exchange.display(true)));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Channel " + this.name + " delivering exchange: " + exchange.display(false)));
        }
        Semaphore semaphore = lock = exchange.getRole() == Role.Provider ? exchange.getConsumerLock(false) : exchange.getProviderLock(false);
        if (lock != null) {
            for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
                l.exchangeDelivered((Exchange)exchange);
            }
            lock.release();
            return;
        }
        try {
            this.executor.execute((Runnable)new ExecutorAwareRunnable(){

                public void run() {
                    ChannelImpl.this.process(exchange);
                }

                public boolean shouldRunSynchronously() {
                    return ChannelImpl.this.shouldRunSynchronously;
                }
            });
        }
        catch (RejectedExecutionException e) {
            if (this.closed.get()) {
                throw new ChannelClosedException();
            }
            throw e;
        }
    }

    protected void process(InternalExchange exchange) {
        try {
            if (exchange.getError() instanceof AbortedException) {
                return;
            }
            if (exchange.getDestination() == null) {
                exchange.setDestination(this.endpoint);
            }
            exchange.setRole(exchange.getRole() == Role.Provider ? Role.Consumer : Role.Provider);
            for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
                l.exchangeDelivered((Exchange)exchange);
            }
            this.endpoint.process((Exchange)exchange);
        }
        catch (RuntimeException e) {
            this.handleFailure(exchange, e, false);
        }
    }

    protected void dispatch(InternalExchange exchange) {
        if (this.closed.get()) {
            throw new ChannelClosedException();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Channel " + this.name + " dispatching exchange: " + exchange.display(true)));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Channel " + this.name + " dispatching exchange: " + exchange.display(false)));
        }
        if (exchange.getSource() == null) {
            exchange.setSource(this.endpoint);
        }
        for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
            l.exchangeSent((Exchange)exchange);
        }
        try {
            this.nmr.getFlowRegistry().dispatch(exchange);
        }
        catch (RuntimeException e) {
            this.handleFailure(exchange, e, true);
        }
    }

    protected void handleFailure(InternalExchange exchange, RuntimeException e, boolean dispatch) {
        LOG.warn((Object)("Error processing exchange " + exchange), (Throwable)e);
        if (dispatch) {
            exchange.setError((Exception)e);
            for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
                l.exchangeFailed((Exchange)exchange);
            }
            throw e;
        }
        if (exchange.getStatus() == Status.Active) {
            try {
                exchange.setError((Exception)e);
                this.send((Exchange)exchange);
            }
            catch (RuntimeException e2) {
                for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
                    l.exchangeFailed((Exchange)exchange);
                }
            }
        } else {
            Semaphore lock;
            exchange.setError((Exception)e);
            Semaphore semaphore = lock = exchange.getRole() == Role.Provider ? exchange.getConsumerLock(false) : exchange.getProviderLock(false);
            if (lock != null) {
                lock.release();
            }
            for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
                l.exchangeFailed((Exchange)exchange);
            }
        }
    }
}

