/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.bindings.soap.SoapConstants;

public class SoapFault
extends Fault {
    private static final long serialVersionUID = 984561453557136677L;
    public static final QName SENDER = SoapConstants.SOAP_12_CODE_SENDER;
    public static final QName RECEIVER = SoapConstants.SOAP_12_CODE_RECEIVER;
    private QName code;
    private QName subcode;
    private String reason;
    private URI node;
    private URI role;
    private Source details;

    public SoapFault(Exception cause) {
        super(cause);
    }

    public SoapFault(QName code, String reason) {
        super(reason);
        this.code = code;
        this.reason = reason;
    }

    public SoapFault(QName code, QName subcode, String reason) {
        super(reason);
        this.code = code;
        this.subcode = subcode;
        this.reason = reason;
    }

    public SoapFault(QName code, String reason, URI node, URI role) {
        super(reason);
        this.code = code;
        this.reason = reason;
        this.node = node;
        this.role = role;
    }

    public SoapFault(QName code, String reason, URI node, URI role, Source details) {
        super(reason);
        this.code = code;
        this.reason = reason;
        this.node = node;
        this.role = role;
        this.details = details;
    }

    public SoapFault(QName code, QName subcode, String reason, URI node, URI role, Source details) {
        super(reason);
        this.code = code;
        this.subcode = subcode;
        this.reason = reason;
        this.node = node;
        this.role = role;
        this.details = details;
    }

    public QName getCode() {
        return this.code;
    }

    public QName getSubcode() {
        return this.subcode;
    }

    public String getReason() {
        return this.reason;
    }

    public URI getNode() {
        return this.node;
    }

    public URI getRole() {
        return this.role;
    }

    public Source getDetails() {
        return this.details;
    }

    public void translateCodeTo11() {
        if (this.code != null) {
            if (this.subcode != null) {
                this.code = this.subcode;
                this.subcode = null;
            } else if (SoapConstants.SOAP_12_CODE_DATAENCODINGUNKNOWN.equals(this.code)) {
                this.code = SoapConstants.SOAP_11_CODE_CLIENT;
            } else if (SoapConstants.SOAP_12_CODE_MUSTUNDERSTAND.equals(this.code)) {
                this.code = SoapConstants.SOAP_11_CODE_MUSTUNDERSTAND;
            } else if (SoapConstants.SOAP_12_CODE_RECEIVER.equals(this.code)) {
                this.code = SoapConstants.SOAP_11_CODE_SERVER;
            } else if (SoapConstants.SOAP_12_CODE_SENDER.equals(this.code)) {
                this.code = SoapConstants.SOAP_11_CODE_CLIENT;
            } else if (SoapConstants.SOAP_12_CODE_VERSIONMISMATCH.equals(this.code)) {
                this.code = SoapConstants.SOAP_11_CODE_VERSIONMISMATCH;
            }
        } else {
            this.code = SoapConstants.SOAP_11_CODE_SERVER;
        }
    }

    public void translateCodeTo12() {
        if (this.code != null && this.subcode == null) {
            if (SoapConstants.SOAP_11_CODE_CLIENT.equals(this.code)) {
                this.code = SoapConstants.SOAP_12_CODE_SENDER;
            } else if (SoapConstants.SOAP_11_CODE_MUSTUNDERSTAND.equals(this.code)) {
                this.code = SoapConstants.SOAP_12_CODE_MUSTUNDERSTAND;
            } else if (SoapConstants.SOAP_11_CODE_SERVER.equals(this.code)) {
                this.code = SoapConstants.SOAP_12_CODE_RECEIVER;
            } else if (SoapConstants.SOAP_11_CODE_VERSIONMISMATCH.equals(this.code)) {
                this.code = SoapConstants.SOAP_12_CODE_VERSIONMISMATCH;
            } else {
                this.subcode = this.code;
                this.code = SoapConstants.SOAP_12_CODE_SENDER;
            }
        } else if (this.code == null) {
            this.code = SoapConstants.SOAP_12_CODE_RECEIVER;
        }
    }
}

