/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.soap.api.Interceptor;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseInterceptorChain
implements InterceptorChain {
    private static final Log LOG = LogFactory.getLog(PhaseInterceptorChain.class);
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();

    @Override
    public void add(Iterable<? extends Interceptor> newhandlers) {
        if (newhandlers == null) {
            return;
        }
        for (Interceptor interceptor : newhandlers) {
            this.add(interceptor);
        }
    }

    @Override
    public Iterable<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void add(Interceptor i) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding interceptor " + i.getId()));
        }
        this.insertInterceptor(i);
    }

    @Override
    public void doIntercept(Message message) {
        ListIterator<Interceptor> iterator = this.getState(message);
        if (iterator == null) {
            iterator = this.interceptors.listIterator();
            this.setState(message, iterator);
        }
        try {
            while (iterator.hasNext()) {
                Interceptor currentInterceptor = iterator.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invoking handleMessage on interceptor " + currentInterceptor.getId()));
                }
                currentInterceptor.handleMessage(message);
            }
        }
        catch (RuntimeException ex) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Interceptor has thrown exception, unwinding now", (Throwable)ex);
            }
            message.setContent(Exception.class, ex);
            while (iterator.hasPrevious()) {
                Interceptor currentInterceptor = iterator.previous();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invoking handleFault on interceptor " + currentInterceptor.getId()));
                }
                currentInterceptor.handleFault(message);
            }
            throw ex;
        }
    }

    protected ListIterator<Interceptor> getState(Message message) {
        Object state = message.get(this.toString());
        return (ListIterator)state;
    }

    protected void setState(Message message, ListIterator<Interceptor> state) {
        message.put(this.toString(), state);
        message.put(InterceptorChain.class, this);
    }

    protected void insertInterceptor(Interceptor interc) {
        if (this.interceptors.size() == 0) {
            this.interceptors.add(interc);
            return;
        }
        int begin = -1;
        int end = this.interceptors.size();
        Set<String> before = interc.getBefore();
        Set<String> after = interc.getAfter();
        for (int i = 0; i < this.interceptors.size(); ++i) {
            Interceptor cmp = this.interceptors.get(i);
            if (cmp.getId() == null) continue;
            if (before.contains(cmp.getId()) && i < end) {
                end = i;
            }
            if (cmp.getBefore().contains(interc.getId()) && i > begin) {
                begin = i;
            }
            if (after.contains(cmp.getId()) && i > begin) {
                begin = i;
            }
            if (!cmp.getAfter().contains(interc.getId()) || i >= end) continue;
            end = i;
        }
        if (end < begin + 1) {
            throw new IllegalStateException("Invalid ordering for interceptor " + interc.getId());
        }
        this.interceptors.add(end, interc);
    }
}

