/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.util.stax;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.stax.DOMStreamReader;
import org.apache.servicemix.soap.util.stax.FragmentStreamReader;
import org.apache.servicemix.soap.util.stax.StaxSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StaxUtil {
    private static XMLOutputFactory xof;
    private static XMLInputFactory xif;

    public static XMLStreamReader createReader(InputStream is) {
        return StaxUtil.createReader(is, null);
    }

    public static XMLStreamReader createReader(InputStream is, String encoding) {
        try {
            return StaxUtil.getXMLInputFactory().createXMLStreamReader(is, encoding);
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }

    public static XMLStreamReader createReader(Source source) {
        if (source instanceof StaxSource) {
            return ((StaxSource)source).getStreamReader();
        }
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            if (node instanceof Element) {
                return new DOMStreamReader((Element)node);
            }
            return new DOMStreamReader(DomUtil.getFirstChildElement(node));
        }
        try {
            return StaxUtil.getXMLInputFactory().createXMLStreamReader(source);
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }

    public static Source createSource(XMLStreamReader reader) {
        if (reader instanceof DOMStreamReader) {
            return new DOMSource(((DOMStreamReader)reader).skipElement());
        }
        return new StaxSource(new FragmentStreamReader(reader));
    }

    public static Element createElement(XMLStreamReader reader) {
        if (reader instanceof DOMStreamReader) {
            return ((DOMStreamReader)reader).skipElement();
        }
        StaxSource src = new StaxSource(new FragmentStreamReader(reader));
        return DomUtil.parse(src).getDocumentElement();
    }

    public static XMLInputFactory getXMLInputFactory() {
        if (xif == null) {
            xif = XMLInputFactory.newInstance();
        }
        return xif;
    }

    public static XMLStreamWriter createWriter(OutputStream os) {
        return StaxUtil.createWriter(os, null);
    }

    public static XMLStreamWriter createWriter(OutputStream os, String encoding) {
        try {
            return StaxUtil.getXMLOutputFactory().createXMLStreamWriter(os, encoding);
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        if (xof == null) {
            xof = XMLOutputFactory.newInstance();
        }
        return xof;
    }

    public static QName readQName(XMLStreamReader reader) throws XMLStreamException {
        String value = reader.getElementText();
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = reader.getNamespaceURI(prefix);
        if (ns == null || localName == null) {
            throw new RuntimeException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int read = 0;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    ++read;
                    StaxUtil.writeStartElement(reader, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read > 0) break;
                    return;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
            }
            event = reader.next();
        }
    }

    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        String local = reader.getLocalName();
        String uri = reader.getNamespaceURI();
        String prefix = reader.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        String boundPrefix = writer.getPrefix(uri);
        boolean writeElementNS = false;
        if (boundPrefix == null || !prefix.equals(boundPrefix)) {
            writeElementNS = true;
        }
        if (uri != null) {
            if (prefix.length() == 0) {
                writer.writeStartElement(local);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeStartElement(prefix, local, uri);
                writer.setPrefix(prefix, uri);
            }
        } else {
            writer.writeStartElement(local);
        }
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String nsURI = reader.getNamespaceURI(i);
            nsPrefix = reader.getNamespacePrefix(i);
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsPrefix.length() == 0) {
                writer.writeDefaultNamespace(nsURI);
            } else {
                writer.writeNamespace(nsPrefix, nsURI);
            }
            if (!nsURI.equals(uri) || !nsPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        if (writeElementNS) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            nsPrefix = reader.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    public static void writeStartElement(XMLStreamWriter writer, String uri, String local, String prefix) throws XMLStreamException {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        String boundPrefix = writer.getPrefix(uri);
        boolean writeElementNS = false;
        if (boundPrefix == null || !prefix.equals(boundPrefix)) {
            writeElementNS = true;
        }
        if (uri != null) {
            if (prefix.length() == 0) {
                writer.writeStartElement(local);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeStartElement(prefix, local, uri);
                writer.setPrefix(prefix, uri);
            }
        } else {
            writer.writeStartElement(local);
        }
        if (writeElementNS) {
            if (prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
            }
        }
    }

    public static void writeStartElement(XMLStreamWriter writer, QName name) throws XMLStreamException {
        String prefix = StaxUtil.choosePrefix(writer, name, false);
        StaxUtil.writeStartElement(writer, name.getNamespaceURI(), name.getLocalPart(), prefix);
    }

    public static void writeTextQName(XMLStreamWriter out, QName name) throws XMLStreamException {
        String prefix = StaxUtil.choosePrefix(out, name, true);
        if ("".equals(prefix)) {
            out.writeCharacters(name.getLocalPart());
        } else {
            out.writeCharacters(prefix + ":" + name.getLocalPart());
        }
    }

    protected static String choosePrefix(XMLStreamWriter out, QName name, boolean declare) throws XMLStreamException {
        String uri = name.getNamespaceURI();
        if (uri == null || "".equals(uri)) {
            if (!"".equals(out.getNamespaceContext().getNamespaceURI(""))) {
                out.setPrefix("", "");
            }
            return "";
        }
        String defPrefix = name.getPrefix();
        if (defPrefix != null && !"".equals(defPrefix)) {
            if (!uri.equals(out.getNamespaceContext().getNamespaceURI(defPrefix))) {
                if (out.getNamespaceContext().getPrefix(uri) != null) {
                    defPrefix = out.getNamespaceContext().getPrefix(uri);
                } else if (out.getPrefix(uri) != null) {
                    defPrefix = out.getPrefix(uri);
                } else if (declare) {
                    out.setPrefix(defPrefix, uri);
                    out.writeNamespace(defPrefix, uri);
                }
            }
        } else if (out.getNamespaceContext().getPrefix(uri) != null) {
            defPrefix = out.getNamespaceContext().getPrefix(uri);
        } else if (out.getPrefix(uri) != null) {
            defPrefix = out.getPrefix(uri);
        } else {
            defPrefix = StaxUtil.getUniquePrefix(out);
            if (declare) {
                out.setPrefix(defPrefix, uri);
                out.writeNamespace(defPrefix, uri);
            }
        }
        return defPrefix;
    }

    protected static String getUniquePrefix(XMLStreamWriter writer) {
        int n = 1;
        while (true) {
            String nsPrefix = "ns" + n;
            if (writer.getNamespaceContext().getNamespaceURI(nsPrefix) == null) {
                return nsPrefix;
            }
            ++n;
        }
    }
}

