/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.handlers.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.common.security.KeystoreManager;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.Handler;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.handlers.security.BaseSecurityCallbackHandler;
import org.apache.servicemix.soap.handlers.security.KeystoreInstanceCrypto;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecurityHandler
extends WSHandler
implements Handler {
    private Map properties = new HashMap();
    private String domain = "servicemix-domain";
    private AuthenticationService authenticationService;
    private boolean required;
    private String sendAction;
    private String receiveAction;
    private String actor;
    private String username;
    private String keystore;
    private Crypto crypto;
    private CallbackHandler handler = new DefaultHandler();
    private ThreadLocal currentSubject = new ThreadLocal();
    private static ThreadLocal currentHandler = new ThreadLocal();

    public WSSecurityHandler() {
        WSSecurityEngine.setWssConfig((WSSConfig)new ServiceMixWssConfig());
    }

    static WSSecurityHandler getCurrentHandler() {
        return (WSSecurityHandler)currentHandler.get();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getReceiveAction() {
        return this.receiveAction;
    }

    public void setReceiveAction(String receiveAction) {
        this.receiveAction = receiveAction;
    }

    public String getSendAction() {
        return this.sendAction;
    }

    public void setSendAction(String action) {
        this.sendAction = action;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean requireDOM() {
        return true;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Object getOption(String key) {
        return this.properties.get(key);
    }

    public void setOption(String key, Object value) {
        this.properties.put(key, value);
    }

    public String getPassword(Object msgContext) {
        return (String)((Context)msgContext).getProperty("password");
    }

    public Object getProperty(Object msgContext, String key) {
        if ("passwordCallbackRef".equals(key)) {
            return this.handler;
        }
        return ((Context)msgContext).getProperty(key);
    }

    public void setPassword(Object msgContext, String password) {
        ((Context)msgContext).setProperty("password", password);
    }

    public void setProperty(Object msgContext, String key, Object value) {
        ((Context)msgContext).setProperty(key, value);
    }

    protected Crypto loadDecryptionCrypto(RequestData reqData) throws WSSecurityException {
        return this.crypto;
    }

    protected Crypto loadEncryptionCrypto(RequestData reqData) throws WSSecurityException {
        return this.crypto;
    }

    public Crypto loadSignatureCrypto(RequestData reqData) throws WSSecurityException {
        return this.crypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context) throws Exception {
        RequestData reqData = new RequestData();
        this.init(context);
        try {
            Timestamp timestamp;
            X509Certificate returnCert;
            WSSecurityEngineResult actionResult;
            reqData.setNoSerialization(true);
            reqData.setMsgContext((Object)context);
            Vector actions = new Vector();
            String action = this.receiveAction;
            if (action == null) {
                throw new IllegalStateException("WSSecurityHandler: No receiveAction defined");
            }
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            Document doc = context.getInMessage().getDocument();
            if (doc == null) {
                throw new IllegalStateException("WSSecurityHandler: The soap message has not been parsed using DOM");
            }
            this.doReceiverAction(doAction, reqData);
            Vector wsResult = null;
            try {
                wsResult = secEngine.processSecurityHeader(doc, this.actor, this.handler, reqData.getSigCrypto(), reqData.getDecCrypto());
            }
            catch (WSSecurityException ex) {
                throw new SoapFault((Exception)((Object)ex));
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                throw new SoapFault((Exception)((Object)new WSSecurityException("WSSecurityHandler: Request does not contain required Security header")));
            }
            if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                this.checkSignatureConfirmation(reqData, wsResult);
            }
            if ((actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)2)) != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, reqData)) {
                throw new SoapFault((Exception)((Object)new WSSecurityException("WSSecurityHandler: the certificate used for the signature is not trusted")));
            }
            actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)32);
            if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                throw new SoapFault((Exception)((Object)new WSSecurityException("WSSecurityHandler: the timestamp could not be validated")));
            }
            if (!this.checkReceiverResults(wsResult, actions)) {
                throw new SoapFault((Exception)((Object)new WSSecurityException("WSSecurityHandler: security processing failed (actions mismatch)")));
            }
            Vector<WSHandlerResult> results = null;
            results = (Vector<WSHandlerResult>)context.getProperty("RECV_RESULTS");
            if (results == null) {
                results = new Vector<WSHandlerResult>();
                context.setProperty("RECV_RESULTS", results);
            }
            WSHandlerResult rResult = new WSHandlerResult(this.actor, wsResult);
            results.add(0, rResult);
            for (WSHandlerResult hr : results) {
                for (WSSecurityEngineResult er : hr.getResults()) {
                    if (er.getPrincipal() == null) continue;
                    context.getInMessage().addPrincipal(er.getPrincipal());
                }
            }
            Subject s = (Subject)this.currentSubject.get();
            if (s != null) {
                for (Principal p : s.getPrincipals()) {
                    context.getInMessage().addPrincipal(p);
                }
            }
        }
        finally {
            reqData.clear();
            this.currentSubject.set(null);
            currentHandler.set(null);
        }
    }

    public void onReply(Context context) throws Exception {
    }

    public void onFault(Context context) throws Exception {
    }

    public void onSend(Context context) throws Exception {
        RequestData reqData = new RequestData();
        reqData.setMsgContext((Object)context);
        this.init(context);
        try {
            Vector actions = new Vector();
            String action = this.sendAction;
            if (action == null) {
                throw new IllegalStateException("WSSecurityHandler: No sendAction defined");
            }
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            if (doAction == 0) {
                return;
            }
            reqData.setUsername((String)this.getOption("user"));
            if (reqData.getUsername() == null || reqData.getUsername().equals("")) {
                String username = (String)this.getProperty(reqData.getMsgContext(), "user");
                if (username != null) {
                    reqData.setUsername(username);
                } else {
                    reqData.setUsername(this.username);
                }
            }
            if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().equals(""))) {
                throw new IllegalStateException("WSSecurityHandler: Empty username for specified action");
            }
            Document doc = context.getInMessage().getDocument();
            if (doc == null) {
                throw new IllegalStateException("WSSecurityHandler: The soap message has not been parsed using DOM");
            }
            this.doSenderAction(doAction, doc, reqData, actions, true);
        }
        catch (WSSecurityException e) {
            throw new SoapFault((Exception)((Object)e));
        }
        finally {
            reqData.clear();
            reqData = null;
            currentHandler.set(null);
        }
    }

    public void onAnswer(Context context) {
    }

    protected void checkUser(String user, Object credentials) throws GeneralSecurityException {
        if (this.authenticationService == null) {
            throw new IllegalArgumentException("authenticationService is null");
        }
        Subject subject = (Subject)this.currentSubject.get();
        if (subject == null) {
            subject = new Subject();
            this.currentSubject.set(subject);
        }
        this.authenticationService.authenticate(subject, this.domain, user, credentials);
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    protected void init(Context context) {
        this.currentSubject.set(null);
        currentHandler.set(this);
        if (context.getProperty("org.apache.servicemix.AuthenticationService") != null) {
            this.setAuthenticationService((AuthenticationService)context.getProperty("org.apache.servicemix.AuthenticationService"));
        }
        if (this.crypto == null && context.getProperty("org.apache.servicemix.KeystoreManager") != null && this.keystore != null) {
            KeystoreManager km = (KeystoreManager)context.getProperty("org.apache.servicemix.KeystoreManager");
            this.setCrypto(new KeystoreInstanceCrypto(km, this.keystore));
        }
    }

    protected class DefaultHandler
    extends BaseSecurityCallbackHandler {
        protected DefaultHandler() {
        }

        protected void processSignature(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
            callback.setPassword("");
        }

        protected void processUsernameTokenUnkown(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
            try {
                WSSecurityHandler.this.checkUser(callback.getIdentifer(), callback.getPassword());
            }
            catch (GeneralSecurityException e) {
                throw new UnsupportedCallbackException((Callback)callback, "Unable to authenticate user");
            }
        }
    }

    private static class ServiceMixWssConfig
    extends WSSConfig {
        private ServiceMixWssConfig() {
        }

        public Processor getProcessor(QName el) throws WSSecurityException {
            if (el.equals(WSSecurityEngine.SIGNATURE)) {
                return new SignatureProcessor();
            }
            return super.getProcessor(el);
        }
    }

    private static class SignatureProcessor
    extends org.apache.ws.security.processor.SignatureProcessor {
        private String signatureId;

        private SignatureProcessor() {
        }

        public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
            WSDocInfoStore.store((WSDocInfo)wsDocInfo);
            X509Certificate[] returnCert = new X509Certificate[1];
            HashSet returnElements = new HashSet();
            byte[][] signatureValue = new byte[1][];
            Principal lastPrincipalFound = null;
            try {
                WSSecurityHandler handler = WSSecurityHandler.getCurrentHandler();
                lastPrincipalFound = this.verifyXMLSignature(elem, crypto, returnCert, returnElements, null, signatureValue);
                if (lastPrincipalFound instanceof WSUsernameTokenPrincipal) {
                    WSUsernameTokenPrincipal p = (WSUsernameTokenPrincipal)lastPrincipalFound;
                    handler.checkUser(p.getName(), p.getPassword());
                } else {
                    handler.checkUser(returnCert[0].getSubjectX500Principal().getName(), returnCert[0]);
                }
            }
            catch (GeneralSecurityException e) {
                throw new WSSecurityException("Unable to authenticate user", (Throwable)e);
            }
            finally {
                WSDocInfoStore.delete((WSDocInfo)wsDocInfo);
            }
            if (lastPrincipalFound instanceof WSUsernameTokenPrincipal) {
                returnResults.add(0, new WSSecurityEngineResult(64, lastPrincipalFound, null, returnElements, signatureValue[0]));
            } else {
                returnResults.add(0, new WSSecurityEngineResult(2, lastPrincipalFound, returnCert[0], returnElements, signatureValue[0]));
            }
            this.signatureId = elem.getAttributeNS(null, "Id");
        }

        public String getId() {
            return this.signatureId;
        }
    }
}

