/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.servicemix.jbi.jaxp.DOMStreamReader;
import org.apache.servicemix.jbi.jaxp.W3CNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class W3CDOMStreamReader
extends DOMStreamReader {
    private Node content;
    private Document document;
    private W3CNamespaceContext context;

    public W3CDOMStreamReader(Element element) {
        super(new DOMStreamReader.ElementFrame(element, null));
        this.document = element.getOwnerDocument();
    }

    public Document getDocument() {
        return this.document;
    }

    protected void newFrame(DOMStreamReader.ElementFrame frame) {
        Element element = this.getCurrentElement();
        frame.uris = new ArrayList<String>();
        frame.prefixes = new ArrayList<String>();
        frame.attributes = new ArrayList();
        if (this.context == null) {
            this.context = new W3CNamespaceContext();
        }
        this.context.setElement(element);
        NamedNodeMap nodes = element.getAttributes();
        String ePrefix = element.getPrefix();
        if (ePrefix == null) {
            ePrefix = "";
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String prefix = node.getPrefix();
            String localName = node.getLocalName();
            String value = node.getNodeValue();
            String name = node.getNodeName();
            if (prefix == null) {
                prefix = "";
            }
            if (name != null && "xmlns".equals(name)) {
                frame.uris.add(value);
                frame.prefixes.add("");
                continue;
            }
            if (prefix.length() > 0 && "xmlns".equals(prefix)) {
                frame.uris.add(value);
                frame.prefixes.add(localName);
                continue;
            }
            if (name.startsWith("xmlns:")) {
                prefix = name.substring(6);
                frame.uris.add(value);
                frame.prefixes.add(prefix);
                continue;
            }
            frame.attributes.add(node);
        }
    }

    protected void endElement() {
        super.endElement();
    }

    Element getCurrentElement() {
        return (Element)this.getCurrentFrame().element;
    }

    protected DOMStreamReader.ElementFrame getChildFrame(int currentChild) {
        return new DOMStreamReader.ElementFrame(this.getCurrentElement().getChildNodes().item(currentChild), this.getCurrentFrame());
    }

    protected int getChildCount() {
        return this.getCurrentElement().getChildNodes().getLength();
    }

    protected int moveToChild(int currentChild) {
        this.content = this.getCurrentElement().getChildNodes().item(currentChild);
        if (this.content instanceof Text) {
            return 4;
        }
        if (this.content instanceof Element) {
            return 1;
        }
        if (this.content instanceof CDATASection) {
            return 12;
        }
        if (this.content instanceof Comment) {
            return 4;
        }
        if (this.content instanceof EntityReference) {
            return 9;
        }
        throw new IllegalStateException();
    }

    public String getElementText() throws XMLStreamException {
        this.frame.ended = true;
        this.currentEvent = 2;
        this.endElement();
        String result = W3CDOMStreamReader.getContent(this.getCurrentElement());
        return result != null ? result : "";
    }

    public String getNamespaceURI(String prefix) {
        DOMStreamReader.ElementFrame frame = this.getCurrentFrame();
        while (null != frame) {
            int index = frame.prefixes.indexOf(prefix);
            if (index != -1) {
                return frame.uris.get(index);
            }
            frame = frame.parent;
        }
        return null;
    }

    public String getAttributeValue(String ns, String local) {
        Attr attr = ns == null || ns.equals("") ? this.getCurrentElement().getAttributeNode(local) : this.getCurrentElement().getAttributeNodeNS(ns, local);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public int getAttributeCount() {
        return this.getCurrentFrame().attributes.size();
    }

    Attr getAttribute(int i) {
        return (Attr)this.getCurrentFrame().attributes.get(i);
    }

    private String getLocalName(Attr attr) {
        String name = attr.getLocalName();
        if (name == null) {
            name = attr.getNodeName();
        }
        return name;
    }

    public QName getAttributeName(int i) {
        Attr at = this.getAttribute(i);
        String prefix = at.getPrefix();
        String ln = this.getLocalName(at);
        String ns = at.getNamespaceURI();
        if (prefix == null) {
            return new QName(ns, ln);
        }
        return new QName(ns, ln, prefix);
    }

    public String getAttributeNamespace(int i) {
        return this.getAttribute(i).getNamespaceURI();
    }

    public String getAttributeLocalName(int i) {
        Attr attr = this.getAttribute(i);
        return this.getLocalName(attr);
    }

    public String getAttributePrefix(int i) {
        return this.getAttribute(i).getPrefix();
    }

    public String getAttributeType(int i) {
        return "CDATA";
    }

    public String getAttributeValue(int i) {
        return this.getAttribute(i).getValue();
    }

    public boolean isAttributeSpecified(int i) {
        return this.getAttribute(i).getValue() != null;
    }

    public int getNamespaceCount() {
        return this.getCurrentFrame().prefixes.size();
    }

    public String getNamespacePrefix(int i) {
        return this.getCurrentFrame().prefixes.get(i);
    }

    public String getNamespaceURI(int i) {
        return this.getCurrentFrame().uris.get(i);
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public String getText() {
        Node node = this.getCurrentElement().getChildNodes().item(this.getCurrentFrame().currentChild);
        return node.getNodeValue();
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public String getEncoding() {
        return null;
    }

    public QName getName() {
        Element el = this.getCurrentElement();
        String prefix = this.getPrefix();
        String ln = this.getLocalName();
        if (prefix == null) {
            return new QName(el.getNamespaceURI(), ln);
        }
        return new QName(el.getNamespaceURI(), ln, prefix);
    }

    public String getLocalName() {
        String name = this.getCurrentElement().getLocalName();
        if (name == null) {
            name = this.getCurrentElement().getNodeName();
        }
        return name;
    }

    public String getNamespaceURI() {
        return this.getCurrentElement().getNamespaceURI();
    }

    public String getPrefix() {
        String prefix = this.getCurrentElement().getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    public String getPIData() {
        throw new UnsupportedOperationException();
    }

    public static String getContent(Node n) {
        if (n == null) {
            return null;
        }
        Node n1 = W3CDOMStreamReader.getChild(n, 3);
        if (n1 == null) {
            return null;
        }
        String s1 = n1.getNodeValue();
        return s1.trim();
    }

    public static Node getChild(Node parent, int type) {
        Node n;
        for (n = parent.getFirstChild(); n != null && type != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return n;
    }
}

