/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.memory;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.Store;

public class MemoryStore
implements Store {
    private static final Log LOG = LogFactory.getLog(MemoryStore.class);
    private Map<String, Object> datas = new ConcurrentHashMap<String, Object>();
    private IdGenerator idGenerator;

    public MemoryStore(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public boolean hasFeature(String name) {
        return false;
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug((Object)("Storing object with id: " + id));
        this.datas.put(id, data);
    }

    public String store(Object data) throws IOException {
        String id = this.idGenerator.generateId();
        this.store(id, data);
        return id;
    }

    public Object load(String id) throws IOException {
        LOG.debug((Object)("Loading object with id: " + id));
        return this.datas.remove(id);
    }
}

