/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.clients;

import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.example.clients.IMessageReceiver;
import org.eclipse.ecf.example.clients.TestSharedObject;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessageSender;

public class XMPPChatRoomClient {
    protected static String CONTAINER_TYPE = "ecf.xmpp.smack";
    Namespace namespace = null;
    IContainer container = null;
    IPresenceContainerAdapter presence = null;
    IChatMessageSender sender = null;
    ID userID = null;
    IChatRoomManager chatmanager = null;
    IChatRoomContainer chatroom = null;
    IChatRoomInfo roomInfo = null;
    IMessageReceiver receiver = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XMPPChatRoomClient() {
        this(null);
    }

    public XMPPChatRoomClient(IMessageReceiver receiver) {
        this.receiver = receiver;
    }

    protected IContainer createContainer() throws ECFException {
        this.container = ContainerFactory.getDefault().createContainer(CONTAINER_TYPE);
        this.namespace = this.container.getConnectNamespace();
        return this.container;
    }

    protected IContainer getContainer() {
        return this.container;
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }

    protected void setupPresenceAdapter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.presence = (IPresenceContainerAdapter)this.container.getAdapter((Class)clazz);
        this.sender = this.presence.getChatManager().getChatMessageSender();
        this.presence.getChatManager().addMessageListener(new IIMMessageListener(){

            public void handleMessageEvent(IIMMessageEvent messageEvent) {
                if (messageEvent instanceof IChatMessageEvent) {
                    IChatMessage m = ((IChatMessageEvent)messageEvent).getChatMessage();
                    XMPPChatRoomClient.this.receiver.handleMessage(m);
                }
            }
        });
    }

    protected IPresenceContainerAdapter getPresenceContainer() {
        return this.presence;
    }

    public void connect(String account, String password) throws ECFException {
        this.createContainer();
        this.setupPresenceAdapter();
        ID targetID = IDFactory.getDefault().createID(this.getNamespace(), account);
        this.getContainer().connect(targetID, ConnectContextFactory.createPasswordConnectContext((String)password));
        this.userID = this.getID(account);
    }

    public void createSharedObject() throws ECFException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.core.sharedobject.ISharedObjectContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISharedObjectContainer socontainer = (ISharedObjectContainer)this.chatroom.getAdapter((Class)clazz);
        ID sharedObjectID = IDFactory.getDefault().createGUID();
        if (socontainer != null) {
            socontainer.getSharedObjectManager().addSharedObject(sharedObjectID, (ISharedObject)new TestSharedObject("testsharedobject"), null);
        }
    }

    public IChatRoomContainer createChatRoom(String chatRoomName) throws Exception {
        this.roomInfo = this.presence.getChatRoomManager().getChatRoomInfo(chatRoomName);
        this.chatroom = this.roomInfo.createChatRoomContainer();
        return this.chatroom;
    }

    public IChatRoomInfo getChatRoomInfo() {
        return this.roomInfo;
    }

    private ID getID(String name) {
        try {
            return IDFactory.getDefault().createID(this.namespace, name);
        }
        catch (IDCreateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendMessage(String jid, String msg) {
        if (this.sender != null) {
            try {
                this.sender.sendChatMessage(this.getID(jid), msg);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isConnected() {
        if (this.container == null) {
            return false;
        }
        return this.container.getConnectedID() != null;
    }

    public synchronized void close() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
            this.presence = null;
            this.sender = null;
            this.receiver = null;
            this.userID = null;
        }
    }
}

