/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public class ServiceInfoResolver
extends TimerTask {
    private final JmDNSImpl jmDNSImpl;
    int count = 0;
    private ServiceInfoImpl info;

    public ServiceInfoResolver(JmDNSImpl jmDNSImpl, ServiceInfoImpl info) {
        this.jmDNSImpl = jmDNSImpl;
        this.info = info;
        info.setDns(this.jmDNSImpl);
        this.jmDNSImpl.addListener(info, new DNSQuestion(info.getQualifiedName(), 255, 1));
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 225L, 225L);
    }

    public void run() {
        try {
            if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this.count++ < 3 && !this.info.hasData()) {
                    long now = System.currentTimeMillis();
                    DNSOutgoing out = new DNSOutgoing(0);
                    out.addQuestion(new DNSQuestion(this.info.getQualifiedName(), 33, 1));
                    out.addQuestion(new DNSQuestion(this.info.getQualifiedName(), 16, 1));
                    if (this.info.getServer() != null) {
                        out.addQuestion(new DNSQuestion(this.info.getServer(), 1, 1));
                    }
                    out.addAnswer((DNSRecord)this.jmDNSImpl.getCache().get(this.info.getQualifiedName(), 33, 1), now);
                    out.addAnswer((DNSRecord)this.jmDNSImpl.getCache().get(this.info.getQualifiedName(), 16, 1), now);
                    if (this.info.getServer() != null) {
                        out.addAnswer((DNSRecord)this.jmDNSImpl.getCache().get(this.info.getServer(), 1, 1), now);
                    }
                    this.jmDNSImpl.send(out);
                } else {
                    this.cancel();
                    this.jmDNSImpl.removeListener(this.info);
                }
            } else if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
                this.jmDNSImpl.removeListener(this.info);
            }
        }
        catch (Throwable throwable) {
            this.jmDNSImpl.recover();
        }
    }
}

