/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jslp.container;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.ServiceContainerEvent;
import org.eclipse.ecf.discovery.ServiceTypeContainerEvent;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.provider.jslp.Activator;
import org.eclipse.ecf.internal.provider.jslp.JSLPDebugOptions;
import org.eclipse.ecf.internal.provider.jslp.JSLPDiscoveryJob;
import org.eclipse.ecf.internal.provider.jslp.Messages;
import org.eclipse.ecf.internal.provider.jslp.ServicePropertiesAdapter;
import org.eclipse.ecf.internal.provider.jslp.ServiceURLAdapter;
import org.eclipse.ecf.provider.jslp.container.JSLPServiceInfo;
import org.eclipse.ecf.provider.jslp.identity.JSLPServiceID;
import org.eclipse.ecf.provider.jslp.identity.JSLPServiceTypeID;

public class JSLPDiscoveryContainer
extends AbstractDiscoveryContainerAdapter
implements IDiscoveryService {
    public static final String NAME = "ecf.discovery.jslp";
    public static long REDISCOVER = Long.parseLong(System.getProperty("net.slp.rediscover", new Long(60000L).toString()));
    private volatile JSLPDiscoveryJob discoveryJob;
    private ID targetID;
    static /* synthetic */ Class class$0;

    public JSLPDiscoveryContainer() {
        IIDFactory iIDFactory = IDFactory.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.jslp.container.JSLPDiscoveryContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super("ecf.namespace.slp", new DiscoveryContainerConfig(iIDFactory.createStringID(clazz.getName())));
    }

    public void connect(ID aTargetID, IConnectContext connectContext) throws ContainerConnectException {
        if (this.targetID != null) {
            throw new ContainerConnectException(Messages.JSLPDiscoveryContainer_0);
        }
        if (this.getConfig() == null) {
            throw new ContainerConnectException(Messages.JSLPDiscoveryContainer_ContainerIsDisposed);
        }
        this.targetID = aTargetID == null ? this.getConfig().getID() : aTargetID;
        this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), aTargetID, (Object)connectContext));
        this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), aTargetID));
    }

    public void disconnect() {
        ID anID = this.getConnectedID();
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), anID));
        this.targetID = null;
        if (this.discoveryJob != null) {
            this.discoveryJob.cancel();
            this.discoveryJob = null;
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), anID));
    }

    public void fireServiceDiscovered(IServiceInfo iinfo) {
        Assert.isNotNull((Object)iinfo);
        if (this.getConfig() != null) {
            this.fireServiceDiscovered((IServiceEvent)new ServiceContainerEvent(iinfo, this.getConfig().getID()));
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"fireServiceDiscovered(IServiceInfo iinfo)", (String)"This IContainer is already disposed thus shouldn't fire events anymore");
        }
    }

    public void fireServiceTypeDiscovered(IServiceTypeID serviceTypeID) {
        Assert.isNotNull((Object)serviceTypeID);
        if (this.getConfig() != null) {
            this.fireServiceTypeDiscovered((IServiceTypeEvent)new ServiceTypeContainerEvent(serviceTypeID, this.getConfig().getID()));
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"fireServiceTypeDiscovered(IServiceInfo iinfo)", (String)"This IContainer is already disposed thus shouldn't fire events anymore");
        }
    }

    public void fireServiceUndiscovered(IServiceInfo iinfo) {
        Assert.isNotNull((Object)iinfo);
        if (this.getConfig() != null) {
            this.fireServiceUndiscovered((IServiceEvent)new ServiceContainerEvent(iinfo, this.getConfig().getID()));
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"fireServiceTypeDiscovered(IServiceInfo iinfo)", (String)"This IContainer is already disposed thus shouldn't fire events anymore");
        }
    }

    public ID getConnectedID() {
        return this.targetID;
    }

    public IServiceInfo getServiceInfo(IServiceID service) {
        Assert.isNotNull((Object)service);
        IServiceInfo[] services = this.getServices(service.getServiceTypeID());
        int i = 0;
        while (i < services.length) {
            block4: {
                IServiceInfo serviceInfo = services[i];
                JSLPServiceID sid = null;
                try {
                    sid = (JSLPServiceID)IDFactory.getDefault().createID(this.getConnectNamespace(), new Object[]{service});
                }
                catch (IDCreateException e1) {
                    Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServiceInfo(IServiceID)", (Throwable)e1);
                    break block4;
                }
                if (service.getName().equals(sid.getName())) {
                    return serviceInfo;
                }
            }
            ++i;
        }
        return null;
    }

    public IServiceTypeID[] getServiceTypes() {
        HashSet<IServiceTypeID> result = new HashSet<IServiceTypeID>();
        try {
            List aList = Activator.getDefault().getLocator().getServiceURLs((String)null, (List)null);
            Iterator itr = aList.iterator();
            while (itr.hasNext()) {
                ServiceURL serviceURL = (ServiceURL)itr.next();
                IServiceTypeID serviceTypeId = (IServiceTypeID)this.getConnectNamespace().createInstance(new Object[]{serviceURL, new String[0]});
                result.add(serviceTypeId);
            }
        }
        catch (ServiceLocationException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServiceTypes(int)", (Throwable)e);
        }
        catch (IDCreateException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServiceTypes(int)", (Throwable)e);
        }
        return result.toArray(new IServiceTypeID[result.size()]);
    }

    public IServiceInfo[] getServices() {
        try {
            return this.convertToIServiceInfo(Activator.getDefault().getLocator().getServiceURLs());
        }
        catch (ServiceLocationException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServices(int)", (Throwable)e);
            return new IServiceInfo[0];
        }
    }

    public IServiceInfo[] getServices(IServiceTypeID type) {
        Assert.isNotNull((Object)type);
        try {
            JSLPServiceTypeID stid = (JSLPServiceTypeID)ServiceIDFactory.getDefault().createServiceTypeID(this.getConnectNamespace(), type);
            return this.convertToIServiceInfo(Activator.getDefault().getLocator().getServiceURLs(stid.getServiceType(), Arrays.asList(stid.getScopes())), type.getScopes());
        }
        catch (IDCreateException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServices(IServiceTypeID)", (Throwable)e);
        }
        catch (ServiceLocationException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServices(int)", (Throwable)e);
        }
        return new IServiceInfo[0];
    }

    public void registerService(IServiceInfo aServiceInfo) {
        Assert.isNotNull((Object)aServiceInfo);
        try {
            JSLPServiceInfo si = new JSLPServiceInfo(aServiceInfo);
            IServiceTypeID stid = si.getServiceID().getServiceTypeID();
            Activator.getDefault().getAdvertiser().register(si.getServiceURL(), Arrays.asList(stid.getScopes()), new ServicePropertiesAdapter(si).toProperties());
        }
        catch (ServiceLocationException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"registerService(IServiceInfo)", (Throwable)e);
            throw new ECFRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void unregisterService(IServiceInfo aServiceInfo) {
        Assert.isNotNull((Object)aServiceInfo);
        JSLPServiceInfo si = new JSLPServiceInfo(aServiceInfo);
        try {
            Activator.getDefault().getAdvertiser().deregister(si.getServiceURL());
        }
        catch (ServiceLocationException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"unregisterService(IServiceInfo)", (Throwable)e);
        }
    }

    public IServiceInfo[] purgeCache() {
        if (this.discoveryJob != null) {
            Collection oldCache = this.discoveryJob.purgeCache();
            oldCache.toArray(new IServiceInfo[oldCache.size()]);
        }
        return super.purgeCache();
    }

    private IServiceInfo[] convertToIServiceInfo(Map serviceURLs) {
        return this.convertToIServiceInfo(serviceURLs, new String[0]);
    }

    private IServiceInfo[] convertToIServiceInfo(Map serviceURLs, String[] scopes) {
        ArrayList<JSLPServiceInfo> tmp = new ArrayList<JSLPServiceInfo>();
        Iterator itr = serviceURLs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            ServiceURL url = (ServiceURL)entry.getKey();
            ServicePropertiesAdapter spa = new ServicePropertiesAdapter((List)entry.getValue());
            String serviceName = spa.getServiceName() == null ? url.toString() : spa.getServiceName();
            JSLPServiceInfo serviceInfo = new JSLPServiceInfo(serviceName, new ServiceURLAdapter(url, scopes), spa.getPriority(), spa.getWeight(), spa);
            tmp.add(serviceInfo);
        }
        return tmp.toArray(new IServiceInfo[tmp.size()]);
    }

    public void addServiceListener(IServiceListener listener) {
        this.instantiateDiscoveryJob();
        super.addServiceListener(listener);
    }

    public void addServiceListener(IServiceTypeID type, IServiceListener listener) {
        this.instantiateDiscoveryJob();
        super.addServiceListener(type, listener);
    }

    public void addServiceTypeListener(IServiceTypeListener listener) {
        this.instantiateDiscoveryJob();
        super.addServiceTypeListener(listener);
    }

    private synchronized void instantiateDiscoveryJob() {
        if (this.discoveryJob == null) {
            this.discoveryJob = new JSLPDiscoveryJob(this);
            this.discoveryJob.schedule();
        }
    }
}

