/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.WriteTransformerMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.TransformationMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationAccessor
extends BasicAccessor {
    private ReadTransformerMetadata m_readTransformer;
    private List<WriteTransformerMetadata> m_writeTransformers;

    public TransformationAccessor() {
        super("<transformation>");
    }

    public TransformationAccessor(Annotation transformation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(transformation, accessibleObject, classAccessor);
        Object writeTransformer;
        Object readTransformer;
        if (transformation != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", transformation));
            this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", transformation));
        }
        if ((readTransformer = this.getAnnotation(ReadTransformer.class)) != null) {
            this.m_readTransformer = new ReadTransformerMetadata((Annotation)readTransformer, accessibleObject);
        }
        this.m_writeTransformers = new ArrayList<WriteTransformerMetadata>();
        Object writeTransformers = this.getAnnotation(WriteTransformers.class);
        if (writeTransformers != null) {
            for (Annotation transformer : (Annotation[])MetadataHelper.invokeMethod("value", writeTransformers)) {
                this.m_writeTransformers.add(new WriteTransformerMetadata(transformer, accessibleObject));
            }
        }
        if ((writeTransformer = this.getAnnotation(WriteTransformer.class)) != null) {
            this.m_writeTransformers.add(new WriteTransformerMetadata((Annotation)writeTransformer, accessibleObject));
        }
    }

    public ReadTransformerMetadata getReadTransformer() {
        return this.m_readTransformer;
    }

    public List<WriteTransformerMetadata> getWriteTransformers() {
        return this.m_writeTransformers;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_readTransformer, accessibleObject);
        this.initXMLObjects(this.m_writeTransformers, accessibleObject);
    }

    @Override
    public void process() {
        TransformationMapping mapping = new TransformationMapping();
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        if (this.getMutable() != null) {
            mapping.setIsMutable(this.getMutable().booleanValue());
        }
        this.setAccessorMethods((DatabaseMapping)mapping);
        this.processProperties((DatabaseMapping)mapping);
        if (this.m_readTransformer != null) {
            this.m_readTransformer.process(mapping, this.getAnnotatedElementName());
        }
        if (this.m_writeTransformers.isEmpty()) {
            mapping.setIsReadOnly(true);
        } else {
            if (this.m_writeTransformers.size() == 1 && !this.m_writeTransformers.get(0).hasFieldName()) {
                this.m_writeTransformers.get(0).setFieldName(this.getAttributeName());
            }
            for (WriteTransformerMetadata writeTransformer : this.m_writeTransformers) {
                writeTransformer.process(mapping, this.getAnnotatedElementName());
            }
        }
        this.getDescriptor().addMapping((DatabaseMapping)mapping);
    }

    public void setReadTransformer(ReadTransformerMetadata readTransformer) {
        this.m_readTransformer = readTransformer;
    }

    public void setWriteTransformers(List<WriteTransformerMetadata> writeTransformers) {
        this.m_writeTransformers = writeTransformers;
    }
}

