/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rwt.widgets.ExternalBrowser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class BrowserTab
extends ExampleTab {
    private static final String DEFAULT_HTML = "<html>\n<head>\n<script type=\"text/javascript\">\n  function show( msg ) {\n    alert( msg );\n}\n</script>\n</head>\n<body>\n  <p id=\"a\">Hello World</p>\n</body>\n</html>";
    private Browser browser;

    public BrowserTab(CTabFolder folder) {
        super(folder, "Browser");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createVisibilityButton();
        this.createUrlAndHTMLSelector(parent);
        this.createExternalBrowserSelector(parent);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.browser = new Browser(parent, this.getStyle());
        this.registerControl((Control)this.browser);
    }

    private void createUrlAndHTMLSelector(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblURL = new Label(composite, 0);
        lblURL.setText("URL");
        final Text txtURL = new Text(composite, 2048);
        txtURL.setText("http://eclipse.org/rap");
        Button btnURL = new Button(composite, 8);
        btnURL.setText("Go");
        btnURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserTab.this.browser.setUrl(txtURL.getText());
            }
        });
        final Label lblHTML = new Label(composite, 0);
        lblHTML.setText("HTML");
        lblHTML.setLayoutData((Object)new GridData(2));
        final Text txtHTML = new Text(composite, 2050);
        txtHTML.setText(DEFAULT_HTML);
        lblHTML.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent evt) {
                GridData data = new GridData(txtURL.getSize().x, lblHTML.getSize().y * 8);
                txtHTML.setLayoutData((Object)data);
            }
        });
        Button btnHTML = new Button(composite, 8);
        btnHTML.setText("Go");
        btnHTML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserTab.this.browser.setText(txtHTML.getText());
            }
        });
        btnHTML.setLayoutData((Object)new GridData(2));
        Label lblExecute = new Label(composite, 0);
        lblExecute.setText("Execute");
        final Text txtExecute = new Text(composite, 2048);
        Button btnExecButton = new Button(composite, 8);
        btnExecButton.setText("Go");
        btnExecButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean result = BrowserTab.this.browser.execute(txtExecute.getText());
                String msg = result ? "Execution was successful." : "Execution was not successful.";
                BrowserTab.this.log(msg);
            }
        });
    }

    private void createExternalBrowserSelector(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblExternalBrowser = new Label(group, 0);
        lblExternalBrowser.setText("External Browser");
        lblExternalBrowser.setLayoutData((Object)BrowserTab.horizontalSpan2());
        Label lblId = new Label(group, 0);
        lblId.setText("Id");
        final Text txtId = new Text(group, 2048);
        txtId.setLayoutData((Object)BrowserTab.grapExcessHorizontalSpace());
        txtId.setText("1");
        Label lblUrl = new Label(group, 0);
        lblUrl.setText("URL");
        final Text txtUrl = new Text(group, 2048);
        txtUrl.setLayoutData((Object)BrowserTab.grapExcessHorizontalSpace());
        txtUrl.setText("http://eclipse.org/rap");
        final Button cbLocationBar = new Button(group, 32);
        cbLocationBar.setLayoutData((Object)BrowserTab.horizontalSpan2());
        cbLocationBar.setText("LOCATION_BAR");
        final Button cbNavigationBar = new Button(group, 32);
        cbNavigationBar.setLayoutData((Object)BrowserTab.horizontalSpan2());
        cbNavigationBar.setText("NAVIGATION_BAR");
        final Button cbStatusBar = new Button(group, 32);
        cbStatusBar.setLayoutData((Object)BrowserTab.horizontalSpan2());
        cbStatusBar.setText("STATUS");
        Button btnOpen = new Button(group, 8);
        btnOpen.setLayoutData((Object)BrowserTab.horizontalSpan2());
        btnOpen.setText("open( id, url, style )");
        btnOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean locationBar = cbLocationBar.getSelection();
                boolean statusBar = cbStatusBar.getSelection();
                boolean navigationBar = cbNavigationBar.getSelection();
                int style = BrowserTab.computeStyle(locationBar, statusBar, navigationBar);
                ExternalBrowser.open((String)txtId.getText(), (String)txtUrl.getText(), (int)style);
            }
        });
        Button btnClose = new Button(group, 8);
        btnClose.setLayoutData((Object)BrowserTab.horizontalSpan2());
        btnClose.setText("close( id )");
        btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExternalBrowser.close((String)txtId.getText());
            }
        });
        Button btnMailTo = new Button(group, 8);
        btnMailTo.setText("mailto:...");
        btnMailTo.setLayoutData((Object)BrowserTab.horizontalSpan2());
        btnMailTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean locationBar = cbLocationBar.getSelection();
                boolean statusBar = cbStatusBar.getSelection();
                boolean navigationBar = cbNavigationBar.getSelection();
                int style = BrowserTab.computeStyle(locationBar, statusBar, navigationBar);
                ExternalBrowser.open((String)"mailto", (String)"mailto:someone@nowhere.org", (int)style);
                ExternalBrowser.close((String)"mailto");
            }
        });
    }

    private static GridData horizontalSpan2() {
        GridData result = new GridData();
        result.horizontalSpan = 2;
        return result;
    }

    private static GridData grapExcessHorizontalSpace() {
        GridData result = new GridData(4, 0x1000000, true, false);
        return result;
    }

    private static int computeStyle(boolean locationBar, boolean statusBar, boolean navigationBar) {
        int style = 0;
        if (locationBar) {
            style |= 2;
        }
        if (navigationBar) {
            style |= 4;
        }
        if (statusBar) {
            style |= 8;
        }
        return style;
    }
}

