/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.HtmlDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ListTab
extends ExampleTab {
    private static final List ELEMENTS = new ArrayList();
    private org.eclipse.swt.widgets.List list;
    private ListViewer listViewer;

    static {
        String text = "A very long item that demonstrates horizontal scrolling in a List";
        ELEMENTS.add(text);
        text = "An item with a linebreak\n(converted to a whitespace)";
        ELEMENTS.add(text);
        text = "...and other control chars: \u0003 \t \u0004 \u000f";
        ELEMENTS.add(text);
        int i = 1;
        while (i <= 25) {
            ELEMENTS.add("Item " + i);
            ++i;
        }
    }

    public ListTab(CTabFolder topFolder) {
        super(topFolder, "List");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("SINGLE", 4);
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("H_SCROLL", 256);
        this.createStyleButton("V_SCROLL", 512);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createCursorCombo();
        this.createSelectionButton();
    }

    protected void createExampleControls(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        int style = this.getStyle();
        this.list = new org.eclipse.swt.widgets.List(parent, style);
        this.list.setLayoutData((Object)new GridData(1808));
        Menu menu = new Menu((Control)this.list);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("Context menu item");
        this.list.setMenu(menu);
        this.listViewer = new ListViewer(this.list);
        this.listViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.listViewer.setInput((Object)ELEMENTS);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                String item = ListTab.this.list.getItem(ListTab.this.list.getSelectionIndex());
                String message = "Selected Item: " + item;
                MessageDialog.openInformation((Shell)ListTab.this.getShell(), (String)"Selection", (String)message);
            }
        });
        this.registerControl((Control)this.list);
        org.eclipse.swt.widgets.List list2 = new org.eclipse.swt.widgets.List(parent, style);
        list2.add("Item 1");
        list2.add("Item 2");
        list2.add("Item 3");
        list2.setLayoutData((Object)new GridData(1808));
        this.registerControl((Control)list2);
        this.createPopupMenu(parent.getShell(), list2);
        int separatorStyle = 266;
        Label separator = new Label(parent, separatorStyle);
        separator.setLayoutData((Object)this.createGridDataWithSpan());
        Label codeLabel = new Label(parent, 64);
        String codeLabelText = "Please note that the content of the left List is provided by a ListViewer with JFace API.";
        codeLabel.setText(codeLabelText);
        codeLabel.setLayoutData((Object)this.createGridDataWithSpan());
        Link link = new Link(parent, 0);
        link.setText("See <a>example code</a>");
        link.setLayoutData((Object)this.createGridDataWithSpan());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private String code;
            {
                this.code = ListTab.this.getExampleCode();
            }

            public void widgetSelected(SelectionEvent event) {
                String title = "ListViewer Example Code";
                HtmlDialog dialog = new HtmlDialog(parent.getShell(), title, this.code);
                dialog.setSize(550, 400);
                dialog.open();
            }
        });
    }

    private GridData createGridDataWithSpan() {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        return gridData;
    }

    private void createPopupMenu(Shell parent, final org.eclipse.swt.widgets.List list) {
        final Menu menu = new Menu((Decorations)parent, 8);
        String[] listItems = list.getItems();
        int i = 0;
        while (i < listItems.length) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(listItems[i]);
            ++i;
        }
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    MenuItem item = items[i];
                    item.setEnabled(list.isSelected(i));
                    ++i;
                }
            }
        });
        list.setMenu(menu);
    }

    private void createSelectionButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Select first");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListTab.this.listViewer.setSelection((ISelection)new StructuredSelection(ELEMENTS.get(0)));
            }
        });
    }

    private String getExampleCode() {
        String result = "<html><head></head></body><pre>class ListContentProvider implements IStructuredContentProvider {\n  public Object[] getElements( final Object inputElement ) {\n    return ( ( java.util.List )inputElement ).toArray();\n  }\n}\n...\njava.util.List elements = ...\n...\nListViewer viewer = new ListViewer( parent );\nviewer.setContentProvider( new ListContentProvider() );\nviewer.setLabelProvider( new LabelProvider() );\njava.util.List input = new ArrayList();\n... // populate list\nviewer.setInput( input );\n</pre></body>";
        return result;
    }

    private static final class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

