/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class SpinnerTab
extends ExampleTab {
    private Spinner spinner;
    private Spinner modifySpinner;

    public SpinnerTab(CTabFolder topFolder) {
        super(topFolder, "Spinner");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("READ_ONLY", 8);
        this.createStyleButton("WRAP", 64);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createRangeControls(parent);
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        this.createCursorCombo();
    }

    protected void createExampleControls(Composite parent) {
        GridLayout gridLayout = new GridLayout(2, false);
        parent.setLayout((Layout)gridLayout);
        Label label = new Label(parent, 0);
        label.setText("Simple Spinner");
        this.spinner = new Spinner(parent, this.getStyle());
        label = new Label(parent, 0);
        label.setText("Spinner with ModifyListener");
        this.modifySpinner = new Spinner(parent, this.getStyle());
        label = new Label(parent, 0);
        label.setText("Current value");
        final Label lblSpinnerValue = new Label(parent, 0);
        lblSpinnerValue.setLayoutData((Object)new GridData(4, 4, true, false));
        lblSpinnerValue.setText(String.valueOf(this.modifySpinner.getSelection()));
        this.modifySpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = String.valueOf(SpinnerTab.this.modifySpinner.getSelection());
                lblSpinnerValue.setText(value);
            }
        });
        this.registerControl((Control)this.spinner);
        this.registerControl((Control)this.modifySpinner);
    }

    private void createRangeControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Settings");
        group.setLayout((Layout)new GridLayout(2, false));
        String minimum = String.valueOf(this.spinner.getMinimum());
        final Text txtMin = this.createLabeledText((Composite)group, "Minimum", minimum);
        String maximum = String.valueOf(this.spinner.getMaximum());
        final Text txtMax = this.createLabeledText((Composite)group, "Maximum", maximum);
        String inc = String.valueOf(this.spinner.getIncrement());
        final Text txtInc = this.createLabeledText((Composite)group, "Increment", inc);
        String pageInc = String.valueOf(this.spinner.getIncrement());
        final Text txtPageInc = this.createLabeledText((Composite)group, "PageIncrement", pageInc);
        String sel = String.valueOf(this.spinner.getSelection());
        final Text txtSelection = this.createLabeledText((Composite)group, "Selection", sel);
        Button btnApply = new Button((Composite)group, 8);
        btnApply.setText("Apply");
        GridData btnApplyData = new GridData(128);
        btnApplyData.horizontalSpan = 2;
        btnApply.setLayoutData((Object)btnApplyData);
        btnApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SpinnerTab.this.spinner.setMinimum(Integer.parseInt(txtMin.getText()));
                SpinnerTab.this.spinner.setMaximum(Integer.parseInt(txtMax.getText()));
                SpinnerTab.this.spinner.setIncrement(Integer.parseInt(txtInc.getText()));
                SpinnerTab.this.spinner.setPageIncrement(Integer.parseInt(txtPageInc.getText()));
                SpinnerTab.this.spinner.setSelection(Integer.parseInt(txtSelection.getText()));
                SpinnerTab.this.modifySpinner.setMinimum(Integer.parseInt(txtMin.getText()));
                SpinnerTab.this.modifySpinner.setMaximum(Integer.parseInt(txtMax.getText()));
                SpinnerTab.this.modifySpinner.setIncrement(Integer.parseInt(txtInc.getText()));
                SpinnerTab.this.modifySpinner.setPageIncrement(Integer.parseInt(txtPageInc.getText()));
                SpinnerTab.this.modifySpinner.setSelection(Integer.parseInt(txtSelection.getText()));
            }
        });
    }

    private Text createLabeledText(Composite parent, String text, String value) {
        Label label = new Label(parent, 0);
        label.setText(text);
        Text result = new Text(parent, 2048);
        result.setText(value);
        result.setLayoutData((Object)new GridData(768));
        return result;
    }
}

