/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.business.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.internal.design.example.business.CommandUtil;
import org.eclipse.rap.internal.design.example.business.builder.CoolbarLayerBuilder;
import org.eclipse.rap.internal.design.example.business.builder.DummyBuilder;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.menus.CommandContributionItem;

public class BusinessCoolBarManager
extends ContributionManager
implements ICoolBarManager2 {
    private static final String ACTIVE = "toolbarOverflowActive";
    private static final String INACTIVE = "toolbarOverflowInactive";
    private static final int SPACING = 25;
    private Map buttonItemMap = new HashMap();
    private ElementBuilder dummyBuilder;
    private Composite coolBar;
    private Composite overflowParent;
    private Button overflowOpenButton;
    private Button overflowCloseButton;
    private Composite overflowLayer;
    private Image preservedWave;
    private Image newWave;
    private List overflowItems = new ArrayList();
    private List commanItems = new ArrayList();
    private Table overflowTable;
    private int indexOfIcon;
    private int indexOfText;
    private int indexOfPulldown;
    private Map commandParamMap = new HashMap();
    private Menu openMenu;
    private FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent event) {
            BusinessCoolBarManager.this.closeOverflow(null);
            BusinessCoolBarManager.this.toggleImages();
        }
    };

    public BusinessCoolBarManager() {
        this.dummyBuilder = new DummyBuilder(null, "org.eclipse.rap.design.example.business.layoutset.coolbar");
    }

    public Control createControl2(Composite parent) {
        this.coolBar = new Composite(parent, 0);
        this.coolBar.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        RowLayout layout = new RowLayout();
        layout.spacing = 25;
        layout.wrap = false;
        layout.marginRight = 0;
        this.coolBar.setLayout((Layout)layout);
        this.coolBar.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (BusinessCoolBarManager.this.openMenu != null) {
                    BusinessCoolBarManager.this.openMenu.setVisible(false);
                }
                BusinessCoolBarManager.this.closeOverflow(null);
                BusinessCoolBarManager.this.update(true);
            }
        });
        return this.coolBar;
    }

    public void dispose() {
        if (this.coolBar != null && !this.coolBar.isDisposed()) {
            this.coolBar.dispose();
        }
        IContributionItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public Control getControl2() {
        return this.coolBar;
    }

    public void refresh() {
    }

    public void resetItemOrder() {
    }

    public void setItems(IContributionItem[] newItems) {
    }

    public void add(IToolBarManager toolBarManager) {
        Assert.isNotNull((Object)toolBarManager);
        super.add((IContributionItem)new ToolBarContributionItem(toolBarManager));
    }

    public IMenuManager getContextMenuManager() {
        return null;
    }

    public boolean getLockLayout() {
        return false;
    }

    public int getStyle() {
        return 0;
    }

    public void setContextMenuManager(IMenuManager menuManager) {
    }

    public void setLockLayout(boolean value) {
    }

    public void add(IAction action) {
        super.add(action);
    }

    public void add(IContributionItem item) {
        super.add(item);
    }

    public void appendToGroup(String groupName, IAction action) {
        super.appendToGroup(groupName, action);
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        super.appendToGroup(groupName, item);
    }

    public IContributionItem find(String id) {
        return super.find(id);
    }

    public IContributionItem[] getItems() {
        return super.getItems();
    }

    public IContributionManagerOverrides getOverrides() {
        return null;
    }

    public void insertAfter(String id, IAction action) {
        super.insertAfter(id, action);
    }

    public void insertAfter(String id, IContributionItem item) {
        super.insertAfter(id, item);
    }

    public void insertBefore(String id, IAction action) {
        super.insertBefore(id, action);
    }

    public void insertBefore(String id, IContributionItem item) {
        super.insertBefore(id, item);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public void markDirty() {
    }

    public void prependToGroup(String groupName, IAction action) {
        super.prependToGroup(groupName, action);
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        super.prependToGroup(groupName, item);
    }

    public IContributionItem remove(String id) {
        return super.remove(id);
    }

    public IContributionItem remove(IContributionItem item) {
        return super.remove(item);
    }

    public void removeAll() {
        super.removeAll();
    }

    public void update(boolean force) {
        if (this.coolBar != null) {
            IContributionItem item;
            Control[] children = this.coolBar.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!children[i].isDisposed()) {
                    children[i].dispose();
                }
                ++i;
            }
            IContributionItem[] items = this.getItems();
            ArrayList<IContributionItem> visibleItems = new ArrayList<IContributionItem>(items.length);
            int i2 = 0;
            while (i2 < items.length) {
                item = items[i2];
                if (item.isVisible()) {
                    visibleItems.add(item);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < visibleItems.size()) {
                item = (IContributionItem)visibleItems.get(i2);
                IToolBarManager manager = null;
                if (item instanceof IToolBarContributionItem) {
                    IToolBarContributionItem toolItem = (IToolBarContributionItem)item;
                    manager = toolItem.getToolBarManager();
                }
                if (manager != null) {
                    IContributionItem[] toolItems = manager.getItems();
                    int j = 0;
                    while (j < toolItems.length) {
                        if (toolItems[j].isVisible()) {
                            if (toolItems[j] instanceof ActionContributionItem) {
                                ActionContributionItem actionItem = (ActionContributionItem)toolItems[j];
                                this.addActionToCoolBar(actionItem);
                            } else if (toolItems[j] instanceof CommandContributionItem) {
                                CommandContributionItem commandItem = (CommandContributionItem)toolItems[j];
                                this.addCommandToCoolBar(commandItem);
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            this.coolBar.pack();
            this.coolBar.layout(true);
            this.manageOverflow();
        }
    }

    private void manageOverflow() {
        int coolbarWidth = this.coolBar.getParent().getSize().x;
        int childrenSize = this.getChildrenSize(this.coolBar);
        while (childrenSize > coolbarWidth) {
            int lastIndex = this.coolBar.getChildren().length - 1;
            Control child = this.coolBar.getChildren()[lastIndex];
            Object object = this.buttonItemMap.get(child);
            ContributionItem item = (ContributionItem)object;
            this.addOverflowItem(item);
            this.activeOverflowOpenButton();
            this.buttonItemMap.remove(child);
            child.dispose();
            child = null;
            childrenSize = this.getChildrenSize(this.coolBar);
        }
        this.checkOverflowActivation();
    }

    private void checkOverflowActivation() {
        boolean foundInToolBar = true;
        int i = 0;
        while (i < this.overflowItems.size() && foundInToolBar) {
            ContributionItem item = (ContributionItem)this.overflowItems.get(i);
            foundInToolBar = this.buttonItemMap.containsValue(item);
            ++i;
        }
        if (foundInToolBar) {
            this.deactivateOverflowButton();
        } else {
            this.activeOverflowOpenButton();
        }
    }

    private void addOverflowItem(ContributionItem item) {
        int indexOf = this.overflowItems.indexOf(item);
        if (indexOf == -1) {
            this.overflowItems.add(item);
        }
    }

    private void deactivateOverflowButton() {
        if (this.overflowOpenButton != null) {
            this.overflowOpenButton.setVisible(false);
        }
    }

    private int getChildrenSize(Composite comp) {
        int result = 0;
        Control[] children = comp.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!children[i].isDisposed()) {
                result += children[i].getSize().x + 25;
            }
            ++i;
        }
        return result;
    }

    private void activeOverflowOpenButton() {
        if (this.overflowParent != null && this.overflowOpenButton == null) {
            this.overflowOpenButton = new Button(this.overflowParent, 8);
            this.overflowOpenButton.setData("org.eclipse.rwt.themeVariant", (Object)INACTIVE);
            this.overflowOpenButton.setLayoutData((Object)this.getOverflowButtonLayoutData());
            this.overflowOpenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BusinessCoolBarManager.this.createOverflowLayer();
                    BusinessCoolBarManager.this.toggleImages();
                }
            });
        }
        this.overflowOpenButton.setVisible(true);
        if (this.overflowCloseButton == null) {
            this.overflowCloseButton = new Button(this.overflowParent, 8);
            this.overflowCloseButton.setData("org.eclipse.rwt.themeVariant", (Object)ACTIVE);
            this.overflowCloseButton.setLayoutData((Object)this.getOverflowButtonLayoutData());
        }
        this.overflowCloseButton.setVisible(false);
    }

    private FormData getOverflowButtonLayoutData() {
        String imageId = "coolbar.overflow.active";
        Image image = this.dummyBuilder.getImage(imageId);
        FormData fdOverFlowButton = new FormData();
        fdOverFlowButton.left = new FormAttachment(10);
        fdOverFlowButton.top = new FormAttachment(58);
        if (image != null) {
            fdOverFlowButton.width = image.getBounds().width;
            fdOverFlowButton.height = image.getBounds().height;
        }
        return fdOverFlowButton;
    }

    private void createOverflowLayer() {
        if (this.overflowLayer == null) {
            CoolbarLayerBuilder layerBuilder = new CoolbarLayerBuilder(this.overflowParent.getParent(), "org.eclipse.rap.design.example.business.layoutset.coolbaroverflow");
            layerBuilder.build();
            this.overflowLayer = (Composite)layerBuilder.getControl();
            this.overflowLayer.addFocusListener(this.focusListener);
            this.newWave = layerBuilder.getImage("coolbar.layer.wave");
        }
        FormData fdParent = (FormData)this.overflowParent.getLayoutData();
        FormData fdLayer = (FormData)this.overflowLayer.getParent().getLayoutData();
        fdLayer.left = fdParent.left;
        this.update(true);
        this.fillOverflowTable();
        this.overflowParent.getParent().layout(true);
        this.overflowLayer.getParent().moveAbove(null);
        this.overflowLayer.getParent().moveBelow((Control)this.overflowParent);
    }

    private void fillOverflowTable() {
        if (this.overflowTable == null) {
            this.overflowTable = new Table(this.overflowLayer, 20);
            this.overflowTable.setBackgroundMode(2);
            FormData fdItemTable = new FormData();
            this.overflowTable.setLayoutData((Object)fdItemTable);
            this.overflowTable.setData("org.eclipse.rwt.themeVariant", (Object)"overflow");
            fdItemTable.top = new FormAttachment(0, 4);
            fdItemTable.left = new FormAttachment(0, 93);
            fdItemTable.bottom = new FormAttachment(100, -2);
            fdItemTable.right = new FormAttachment(100);
            this.overflowTable.setBackgroundMode(2);
            this.overflowTable.setHeaderVisible(false);
            this.overflowTable.setLinesVisible(false);
            TableColumn iconColumn = new TableColumn(this.overflowTable, 0);
            iconColumn.setResizable(false);
            iconColumn.setMoveable(false);
            TableColumn textColumn = new TableColumn(this.overflowTable, 0);
            TableColumn pulldownColumn = new TableColumn(this.overflowTable, 0);
            pulldownColumn.setResizable(false);
            pulldownColumn.setMoveable(false);
            this.indexOfIcon = this.overflowTable.indexOf(iconColumn);
            this.indexOfText = this.overflowTable.indexOf(textColumn);
            this.indexOfPulldown = this.overflowTable.indexOf(pulldownColumn);
            this.overflowTable.addFocusListener(this.focusListener);
        }
        this.emptyOverflowTable();
        this.overflowTable.setVisible(true);
        final HashMap<Integer, Action> itemMap = new HashMap<Integer, Action>();
        final HashMap<Action, CommandContributionItem> actionMap = new HashMap<Action, CommandContributionItem>();
        MouseAdapter mousDownListner = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableItem[] selection = BusinessCoolBarManager.this.overflowTable.getSelection();
                TableItem item = selection[0];
                int indexOf = BusinessCoolBarManager.this.overflowTable.indexOf(item);
                Rectangle bounds = item.getBounds(BusinessCoolBarManager.this.indexOfPulldown);
                Object object = itemMap.get(new Integer(indexOf));
                Action action = null;
                if (object != null && object instanceof Action) {
                    action = (Action)object;
                }
                if (e.x < bounds.x && action != null) {
                    BusinessCoolBarManager.this.closeOverflow(this);
                    action.run();
                } else {
                    Menu pulldownMenu = BusinessCoolBarManager.this.getPulldownMenu(action, (Control)BusinessCoolBarManager.this.overflowTable, actionMap);
                    if (pulldownMenu != null) {
                        Display display = BusinessCoolBarManager.this.overflowTable.getDisplay();
                        Point newLoc = display.map((Control)BusinessCoolBarManager.this.overflowTable, null, bounds.x + 20, bounds.y);
                        pulldownMenu.setLocation(newLoc);
                        pulldownMenu.setVisible(true);
                        BusinessCoolBarManager.this.openMenu = pulldownMenu;
                        4 adapter = this;
                        pulldownMenu.addListener(23, new Listener(this, adapter, pulldownMenu){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ MouseAdapter val$adapter;
                            private final /* synthetic */ Menu val$pulldownMenu;
                            {
                                this.this$1 = var1_1;
                                this.val$adapter = mouseAdapter;
                                this.val$pulldownMenu = menu;
                            }

                            public void handleEvent(Event event) {
                                BusinessCoolBarManager.access$0(4.access$0(this.this$1), this.val$adapter);
                                this.val$pulldownMenu.removeListener(23, (Listener)this);
                            }
                        });
                    }
                }
            }

            static /* synthetic */ BusinessCoolBarManager access$0(4 var0) {
                return var0.BusinessCoolBarManager.this;
            }
        };
        this.overflowTable.addMouseListener((MouseListener)mousDownListner);
        this.clearCommandItems();
        String key = "coolbar.layer.arrow";
        DummyBuilder dummy = new DummyBuilder(null, "org.eclipse.rap.design.example.business.layoutset.coolbaroverflow");
        Image arrowIcon = dummy.getImage(key);
        int i = 0;
        while (i < this.overflowItems.size()) {
            ContributionItem contrib = (ContributionItem)this.overflowItems.get(i);
            if (!this.buttonItemMap.containsValue(contrib)) {
                TableItem tableItem = new TableItem(this.overflowTable, 0);
                Action action = null;
                if (contrib instanceof ActionContributionItem) {
                    ActionContributionItem actionItem = (ActionContributionItem)contrib;
                    action = (Action)actionItem.getAction();
                } else if (contrib instanceof CommandContributionItem) {
                    CommandContributionItem item = (CommandContributionItem)contrib;
                    action = CommandUtil.wrapCommand(item, this.coolBar);
                    actionMap.put(action, item);
                }
                Integer value = new Integer(this.overflowTable.indexOf(tableItem));
                itemMap.put(value, action);
                ImageDescriptor imageDescriptor = action.getImageDescriptor();
                if (imageDescriptor != null) {
                    Image icon = imageDescriptor.createImage();
                    tableItem.setImage(this.indexOfIcon, icon);
                }
                this.setTableItemStyle(tableItem);
                String text = action.getText();
                tableItem.setText(this.indexOfText, text.replaceAll("&", ""));
                tableItem.setData("org.eclipse.rwt.themeVariant", (Object)"overflow");
                if (action.getStyle() == 4) {
                    tableItem.setImage(this.indexOfPulldown, arrowIcon);
                }
            }
            ++i;
        }
        this.overflowTable.getColumn(this.indexOfIcon).pack();
        this.overflowTable.getColumn(this.indexOfText).pack();
        this.overflowTable.getColumn(this.indexOfPulldown).pack();
        this.overflowTable.pack();
        this.overflowLayer.layout(true, true);
        this.overflowTable.setFocus();
    }

    private Menu getPulldownMenu(Action action, Control parent, Map actionMap) {
        Object object;
        Menu result = null;
        if (action == null) {
            throw new IllegalArgumentException();
        }
        IMenuCreator menuCreator = action.getMenuCreator();
        if (menuCreator != null) {
            result = menuCreator.getMenu(parent);
        }
        if (actionMap != null && (object = actionMap.get(action)) != null && object instanceof CommandContributionItem) {
            CommandContributionItem item = (CommandContributionItem)object;
            CommandUtil.CommandParameter param = this.extractCommandInformation(item);
            result = param.getMenu();
        }
        return result;
    }

    private void emptyOverflowTable() {
        TableItem[] items = this.overflowTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        this.overflowTable.clearAll();
        this.overflowTable.removeAll();
    }

    private void clearCommandItems() {
        int i = 0;
        while (i < this.commanItems.size()) {
            MenuItem item = (MenuItem)this.commanItems.get(i);
            this.destroyItem((Item)item);
            ++i;
        }
    }

    private void setTableItemStyle(TableItem tableItem) {
        Color color = this.dummyBuilder.getColor("coolbar.overflow.color");
        tableItem.setForeground(color);
    }

    private void toggleImages() {
        Image wave = null;
        if (this.overflowOpenButton.isVisible()) {
            this.overflowOpenButton.setVisible(false);
            this.overflowCloseButton.setVisible(true);
            wave = this.newWave;
            this.overflowLayer.getParent().setVisible(true);
            this.overflowLayer.setFocus();
        } else {
            this.overflowCloseButton.setVisible(false);
            this.overflowOpenButton.setVisible(true);
            this.overflowLayer.getParent().setVisible(false);
            wave = this.preservedWave;
        }
        this.overflowParent.setBackgroundImage(wave);
    }

    private void closeOverflow(MouseAdapter adapter) {
        if (this.overflowLayer != null && this.preservedWave != null) {
            boolean opened = this.overflowLayer.getParent().isVisible();
            if (opened) {
                this.overflowLayer.getParent().setVisible(false);
                this.overflowParent.setBackgroundImage(this.preservedWave);
                this.overflowOpenButton.setData("org.eclipse.rwt.themeVariant", (Object)INACTIVE);
                this.overflowItems.clear();
                this.clearCommandItems();
            }
            if (adapter != null) {
                this.overflowTable.removeMouseListener((MouseListener)adapter);
            }
        }
    }

    private void addCommandToCoolBar(CommandContributionItem item) {
        CommandUtil.CommandParameter param = this.extractCommandInformation(item);
        if (param.getStyle() == 4) {
            this.createPullDownButton((ContributionItem)item, (IAction)CommandUtil.wrapCommand(item, this.coolBar), param.getStyle());
        } else {
            final Button button = new Button(this.coolBar, param.getStyle());
            Command command = param.getCommand();
            button.setData((Object)command);
            button.setText(param.getText());
            button.setToolTipText(param.getTooltipText());
            button.setData("org.eclipse.rwt.themeVariant", (Object)"coolBar");
            button.setImage(param.getIcon());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Command buttonCommand = (Command)button.getData();
                    CommandUtil.executeCommand(buttonCommand);
                }
            });
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BusinessCoolBarManager.this.buttonItemMap.remove(button);
                }
            });
            this.buttonItemMap.put(button, item);
        }
    }

    private CommandUtil.CommandParameter extractCommandInformation(CommandContributionItem item) {
        CommandUtil.CommandParameter result = null;
        Object object = this.commandParamMap.get(item);
        if (object == null) {
            result = CommandUtil.extractCommandInformation(item, this.coolBar);
            this.commandParamMap.put(item, result);
        } else {
            result = (CommandUtil.CommandParameter)object;
        }
        return result;
    }

    private void destroyItem(Item item) {
        item.dispose();
        item = null;
    }

    private void adjustButtonBounds(Button button) {
        Image image = this.dummyBuilder.getImage("coolbar.button.bg");
        int height = image.getBounds().height;
        button.setSize(button.getSize().x, height);
    }

    private void addActionToCoolBar(ActionContributionItem item) {
        IAction action = item.getAction();
        int actionStyle = action.getStyle();
        int style = this.getButtonStyle(actionStyle);
        if (action.getStyle() == 4) {
            this.createPullDownButton((ContributionItem)item, action, style);
        } else {
            final Button button = this.createCoolBarButton(this.coolBar, style, action);
            this.buttonItemMap.put(button, item);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BusinessCoolBarManager.this.buttonItemMap.remove(button);
                }
            });
        }
    }

    private void createPullDownButton(ContributionItem item, IAction action, int style) {
        final Composite buttonParent = new Composite(this.coolBar, 0);
        this.buttonItemMap.put(buttonParent, item);
        RowLayout layout = new RowLayout(256);
        layout.spacing = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        buttonParent.setLayout((Layout)layout);
        buttonParent.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        Button button = this.createCoolBarButton(buttonParent, 8, action);
        buttonParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BusinessCoolBarManager.this.buttonItemMap.remove(buttonParent);
                BusinessCoolBarManager.this.clearComposite(buttonParent);
            }
        });
        final Button arrow = new Button(buttonParent, 8);
        arrow.setData("org.eclipse.rwt.themeVariant", (Object)"coolBarPulldown");
        arrow.setImage(this.dummyBuilder.getImage("coolbar.arrow"));
        final Menu menu = this.getItemMenu(item, action, button);
        arrow.setText(" ");
        arrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (menu != null) {
                    menu.setVisible(true);
                    BusinessCoolBarManager.this.openMenu = menu;
                    Display display = arrow.getDisplay();
                    Point newLoc = display.map((Control)arrow, null, 10, arrow.getSize().y);
                    menu.setLocation(newLoc);
                }
            }
        });
        buttonParent.layout(true);
    }

    private Menu getItemMenu(ContributionItem item, IAction action, Button button) {
        Menu menu;
        if (item instanceof CommandContributionItem) {
            CommandUtil.CommandParameter param = this.extractCommandInformation((CommandContributionItem)item);
            menu = param.getMenu();
        } else {
            menu = this.getPulldownMenu((Action)action, (Control)button, null);
        }
        return menu;
    }

    private void clearComposite(Composite comp) {
        Control[] children = comp.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    private int getButtonStyle(int actionStyle) {
        int style;
        switch (actionStyle) {
            case 2: {
                style = 32;
                break;
            }
            case 4: {
                style = 8;
                break;
            }
            case 8: {
                style = 16;
                break;
            }
            default: {
                style = 8;
            }
        }
        return style;
    }

    private Button createCoolBarButton(Composite parent, int style, final IAction action) {
        Button button = new Button(parent, style);
        this.adjustButtonBounds(button);
        button.setText(action.getText());
        button.setToolTipText(action.getToolTipText());
        if (action.getImageDescriptor() != null) {
            button.setImage(action.getImageDescriptor().createImage());
        }
        button.setData("org.eclipse.rwt.themeVariant", (Object)"coolBar");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    action.run();
                }
                catch (Exception exception) {}
            }
        });
        return button;
    }

    public void setOverflowParent(Composite overflowParent) {
        this.overflowParent = overflowParent;
        this.preservedWave = overflowParent.getBackgroundImage();
    }
}

