/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.business.managers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.internal.design.example.business.popups.MenuBarPopup;
import org.eclipse.rap.ui.interactiondesign.layout.LayoutRegistry;
import org.eclipse.rap.ui.interactiondesign.layout.model.LayoutSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BusinessMenuBarManager
extends MenuManager {
    private static final String PLUGIN_ID = "org.eclipse.rap.design.example";
    private Composite menuParent;
    private List buttonList = new ArrayList();

    public void fill(Composite parent) {
        this.menuParent = parent;
        RowLayout layout = new RowLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        this.update(false, false);
    }

    protected void update(boolean force, boolean recursive) {
        if (this.menuParent != null) {
            this.disposeButtons();
            IContributionItem[] items = this.getItems();
            if (items.length > 0 && this.menuParent != null) {
                int i = 0;
                while (i < items.length) {
                    IContributionItem item = items[i];
                    if (item.isVisible()) {
                        this.makeEntry(item);
                    }
                    ++i;
                }
            }
            this.menuParent.layout(true, true);
        }
    }

    private void disposeButtons() {
        int i = 0;
        while (i < this.buttonList.size()) {
            Control control = (Control)this.buttonList.get(i);
            control.dispose();
            ++i;
        }
    }

    private void makeEntry(IContributionItem item) {
        if (item instanceof MenuManager) {
            this.makeManagerEntry((MenuManager)item);
        } else if (item instanceof SubContributionItem) {
            SubContributionItem subItem = (SubContributionItem)item;
            IContributionItem innerItem = subItem.getInnerItem();
            if (innerItem instanceof MenuManager) {
                this.makeManagerEntry((MenuManager)innerItem);
            }
        } else if (item instanceof ActionContributionItem) {
            ActionContributionItem actionItem = (ActionContributionItem)item;
            IAction action = actionItem.getAction();
            this.makeActionEntry(action);
        }
    }

    private void makeActionEntry(final IAction action) {
        Button button = new Button(this.menuParent, 0x800008);
        button.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
        button.setText(action.getText());
        button.setToolTipText(action.getToolTipText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        this.buttonList.add(button);
    }

    private void makeManagerEntry(final MenuManager manager) {
        Composite buttonParent = new Composite(this.menuParent, 0);
        buttonParent.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        RowLayout layout = new RowLayout();
        layout.spacing = 0;
        layout.marginLeft = -6;
        layout.marginTop = -1;
        layout.marginRight = 33;
        buttonParent.setLayout((Layout)layout);
        final Button textButton = new Button(buttonParent, 0x800008);
        textButton.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
        textButton.setText(manager.getMenuText());
        Button iconButton = new Button(buttonParent, 0x800008);
        iconButton.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
        LayoutRegistry registry = LayoutRegistry.getInstance();
        org.eclipse.rap.ui.interactiondesign.layout.model.Layout activeLayout = registry.getActiveLayout();
        LayoutSet set = activeLayout.getLayoutSet("org.eclipse.rap.design.example.business.layoutset.menubar");
        String path = set.getImagePath("menubar.arrow");
        ImageDescriptor imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
        iconButton.setImage(imgDesc.createImage());
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusinessMenuBarManager.this.makePopup(manager, textButton);
            }
        };
        textButton.addSelectionListener((SelectionListener)selAdapter);
        iconButton.addSelectionListener((SelectionListener)selAdapter);
        this.buttonList.add(buttonParent);
    }

    private void makePopup(MenuManager manager, Button textButton) {
        IContributionItem[] items = manager.getItems();
        if (items.length > 0) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Shell shell = workbench.getActiveWorkbenchWindow().getShell();
            MenuBarPopup popup = new MenuBarPopup(shell, 16384, false, false, false, false, false, null, null, manager, null);
            popup.open();
            Display display = shell.getDisplay();
            Point pos = display.map((Control)textButton, null, 0, textButton.getSize().y);
            Shell popupShell = popup.getShell();
            popupShell.setLocation(pos);
            popupShell.setActive();
        }
    }
}

