/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.CommonPatterns;
import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.internal.graphics.IColor;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class JSWriter {
    public static JSVar WIDGET_MANAGER_REF = new JSVar("wm");
    public static JSVar WIDGET_REF = new JSVar("w");
    private static final JSVar TARGET_REF = new JSVar("t");
    private static final String WRITER_MAP;
    private static final String HAS_WINDOW_MANAGER;
    private static final String CURRENT_WIDGET_REF;
    private static final Map setterNames;
    private static final Map getterNames;
    private static final Map resetterNames;
    private final Widget widget;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.JSWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WRITER_MAP = String.valueOf(clazz.getName()) + "#map";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.lifecycle.JSWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HAS_WINDOW_MANAGER = String.valueOf(clazz2.getName()) + "#hasWindowManager";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.rwt.lifecycle.JSWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CURRENT_WIDGET_REF = String.valueOf(clazz3.getName()) + "#currentWidgetRef";
        setterNames = new HashMap();
        getterNames = new HashMap();
        resetterNames = new HashMap();
    }

    public static JSWriter getWriterFor(Widget widget) {
        JSWriter result;
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HashMap<Widget, JSWriter> map = (HashMap<Widget, JSWriter>)stateInfo.getAttribute(WRITER_MAP);
        if (map == null) {
            map = new HashMap<Widget, JSWriter>();
            stateInfo.setAttribute(WRITER_MAP, map);
        }
        if (map.containsKey(widget)) {
            result = (JSWriter)map.get(widget);
        } else {
            result = new JSWriter(widget);
            map.put(widget, result);
        }
        return result;
    }

    public static JSWriter getWriterForResetHandler() {
        return new JSWriter(null);
    }

    private JSWriter(Widget iwidgetdget) {
        this.widget = iwidgetdget;
    }

    public void newWidget(String className) throws IOException {
        this.newWidget(className, null);
    }

    public void newWidget(String className, Object[] args) throws IOException {
        this.ensureWidgetManager();
        String typePoolId = this.getTypePoolId(this.widget);
        StringBuffer buffer = new StringBuffer();
        buffer.append("var w = wm.newWidget( \"");
        buffer.append(WidgetUtil.getId((Widget)this.widget));
        buffer.append("\", \"");
        buffer.append(this.getJSParentId(this.widget));
        buffer.append("\", ");
        buffer.append(this.useSetParent());
        buffer.append(", ");
        Integer poolIdHashCode = typePoolId == null ? null : new Integer(typePoolId.hashCode());
        buffer.append(poolIdHashCode);
        buffer.append(", \"");
        buffer.append(className);
        buffer.append("\"");
        buffer.append(JSWriter.createParamList(", '", args, "'", false));
        buffer.append(" );");
        JSWriter.getWriter().write(buffer.toString());
        JSWriter.setCurrentWidgetRef(this.widget);
        if (this.widget instanceof Shell) {
            this.call("addToDocument", null);
        }
    }

    public void setParent(String parentId) throws IOException {
        this.call(WIDGET_MANAGER_REF, "setParent", new Object[]{this.widget, parentId});
    }

    public void set(String jsProperty, String value) throws IOException {
        this.call(JSWriter.getSetterName(jsProperty), new Object[]{value});
    }

    public void set(String jsProperty, int value) throws IOException {
        this.set(jsProperty, new int[]{value});
    }

    public void set(String jsProperty, float value) throws IOException {
        this.set(jsProperty, new float[]{value});
    }

    public void set(String jsProperty, boolean value) throws IOException {
        this.set(jsProperty, new boolean[]{value});
    }

    public void set(String jsProperty, int[] values) throws IOException {
        String functionName = JSWriter.getSetterName(jsProperty);
        Object[] integers = new Integer[values.length];
        int i = 0;
        while (i < values.length) {
            integers[i] = new Integer(values[i]);
            ++i;
        }
        this.call(this.widget, functionName, integers);
    }

    public void set(String jsProperty, float[] values) throws IOException {
        String functionName = JSWriter.getSetterName(jsProperty);
        Object[] floats = new Float[values.length];
        int i = 0;
        while (i < values.length) {
            floats[i] = new Float(values[i]);
            ++i;
        }
        this.call(this.widget, functionName, floats);
    }

    public void set(String jsProperty, boolean[] values) throws IOException {
        this.ensureWidgetRef();
        String functionName = JSWriter.getSetterName(jsProperty);
        Object[] parameters = new Boolean[values.length];
        int i = 0;
        while (i < values.length) {
            parameters[i] = values[i];
            ++i;
        }
        this.call(this.widget, functionName, parameters);
    }

    public void set(String jsProperty, Object value) throws IOException {
        this.set(jsProperty, new Object[]{value});
    }

    public void set(String jsProperty, Object[] values) throws IOException {
        this.call(this.widget, JSWriter.getSetterName(jsProperty), values);
    }

    public void set(String[] jsPropertyChain, Object[] values) throws IOException {
        this.call(this.widget, this.createPropertyChain(jsPropertyChain, false), values);
    }

    public boolean set(String javaProperty, String jsProperty, Object newValue) throws IOException {
        boolean changed;
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)this.widget);
        boolean bl = changed = !adapter.isInitialized() || WidgetLCAUtil.hasChanged(this.widget, javaProperty, newValue);
        if (changed) {
            this.set(jsProperty, newValue);
        }
        return changed;
    }

    public boolean set(String javaProperty, String jsProperty, Object newValue, Object defValue) throws IOException {
        boolean changed = WidgetLCAUtil.hasChanged(this.widget, javaProperty, newValue, defValue);
        if (changed) {
            this.set(jsProperty, new Object[]{newValue});
        }
        return changed;
    }

    public void reset(String jsProperty) throws IOException {
        this.call(this.widget, JSWriter.getResetterName(jsProperty), null);
    }

    public void reset(String[] jsPropertyChain) throws IOException {
        this.call(this.widget, this.createPropertyChain(jsPropertyChain, true), null);
    }

    public void addListener(String property, String eventType, String listener) throws IOException {
        this.ensureWidgetRef();
        if (property == null) {
            if (listener.startsWith("this.")) {
                String thisListener = listener.substring(5);
                String code = "w.addEventListener( \"{0}\", w.{1}, w );";
                JSWriter.write(code, eventType, thisListener);
            } else {
                String code = "w.addEventListener( \"{0}\", {1} );";
                JSWriter.write(code, eventType, listener);
            }
        } else {
            String code = "w.{0}().addEventListener( \"{1}\", {2} );";
            JSWriter.write(code, JSWriter.getGetterName(property), eventType, listener);
        }
    }

    public void addListener(String eventType, String listener) throws IOException {
        this.addListener(null, eventType, listener);
    }

    public void updateListener(String property, JSListenerInfo info, String javaListener, boolean hasListeners) throws IOException {
        if (info.getJSListenerType() == JSListenerType.ACTION) {
            this.updateActionListener(property, info, javaListener, hasListeners);
        } else {
            this.updateStateAndActionListener(property, info, javaListener, hasListeners);
        }
    }

    public void updateListener(JSListenerInfo info, String javaListener, boolean hasListeners) throws IOException {
        this.updateListener(null, info, javaListener, hasListeners);
    }

    public void removeListener(String eventType, String listener) throws IOException {
        this.removeListener(null, eventType, listener);
    }

    public void removeListener(String property, String eventType, String listener) throws IOException {
        this.ensureWidgetRef();
        if (property == null) {
            if (listener.startsWith("this.")) {
                String thisListener = listener.substring(5);
                String code = "w.removeEventListener( \"{0}\", w.{1}, w );";
                JSWriter.write(code, eventType, thisListener);
            } else {
                String code = "w.removeEventListener( \"{0}\", {1} );";
                JSWriter.write(code, eventType, listener);
            }
        } else {
            String code = "w.{0}().removeEventListener( \"{1}\", {2} );";
            JSWriter.write(code, JSWriter.getGetterName(property), eventType, listener);
        }
    }

    public void call(String function, Object[] args) throws IOException {
        this.call(this.widget, function, args);
    }

    public void call(Widget target, String function, Object[] args) throws IOException {
        JSVar refVariable;
        this.ensureWidgetManager();
        if (target == this.widget) {
            this.ensureWidgetRef();
            refVariable = WIDGET_REF;
        } else {
            refVariable = TARGET_REF;
            this.writeVarAssignment(refVariable, JSWriter.createFindWidgetById(target));
        }
        String params = JSWriter.createParamList(args);
        this.writeCall(refVariable, function, params);
    }

    public void call(JSVar target, String function, Object[] args) throws IOException {
        this.ensureWidgetManager();
        String params = JSWriter.createParamList(args);
        this.writeCall(target, function, params);
    }

    public void startCall(JSVar target, String function, Object[] args) throws IOException {
        this.ensureWidgetManager();
        String params = JSWriter.createParamList(" ", args, "", false);
        JSWriter.write("{0}.{1}({2}", target, function, params);
    }

    public void endCall(Object[] args) throws IOException {
        JSWriter.getWriter().write(JSWriter.createParamList("", args, "", false));
        JSWriter.getWriter().write(" );");
    }

    public void callStatic(String function, Object[] args) throws IOException {
        this.ensureWidgetManager();
        String params = JSWriter.createParamList(args);
        StringBuffer buffer = new StringBuffer();
        buffer.append(function);
        buffer.append('(');
        buffer.append(params);
        buffer.append(");");
        JSWriter.getWriter().write(buffer.toString());
    }

    public void callFieldAssignment(JSVar target, String field, String value) throws IOException {
        JSWriter.write("{0}.{1} = {2};", target, field, value);
    }

    public void dispose() throws IOException {
        this.ensureWidgetManager();
        String widgetId = WidgetUtil.getId((Widget)this.widget);
        if (this.widget instanceof Control) {
            ControlLCAUtil.resetActivateListener((Control)this.widget);
        }
        this.call(WIDGET_MANAGER_REF, "dispose", new Object[]{widgetId});
    }

    private void updateActionListener(String property, JSListenerInfo info, String javaListener, boolean hasListeners) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)this.widget);
        if (adapter.isInitialized()) {
            Boolean hadListeners = (Boolean)adapter.getPreserved(javaListener);
            if (hadListeners == null || Boolean.FALSE.equals(hadListeners)) {
                if (hasListeners) {
                    this.addListener(property, info.getEventType(), info.getJSListener());
                }
            } else if (!hasListeners) {
                this.removeListener(property, info.getEventType(), info.getJSListener());
            }
        } else if (hasListeners) {
            this.addListener(property, info.getEventType(), info.getJSListener());
        }
    }

    private void updateStateAndActionListener(String property, JSListenerInfo info, String javaListener, boolean hasListeners) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)this.widget);
        if (adapter.isInitialized()) {
            Boolean hadListeners = (Boolean)adapter.getPreserved(javaListener);
            if (hadListeners == null || Boolean.FALSE.equals(hadListeners)) {
                if (hasListeners) {
                    this.removeListener(property, info.getEventType(), info.getJSListener());
                    this.addListener(property, info.getEventType(), this.createJsActionListener(info));
                }
            } else if (!hasListeners) {
                this.removeListener(property, info.getEventType(), this.createJsActionListener(info));
                this.addListener(property, info.getEventType(), info.getJSListener());
            }
        } else if (hasListeners) {
            this.addListener(property, info.getEventType(), this.createJsActionListener(info));
        } else {
            this.addListener(property, info.getEventType(), info.getJSListener());
        }
    }

    private String createJsActionListener(JSListenerInfo info) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(info.getJSListener());
        buffer.append("Action");
        return buffer.toString();
    }

    private Boolean useSetParent() {
        return !(this.widget instanceof Shell) && this.widget instanceof Control ? Boolean.TRUE : Boolean.FALSE;
    }

    private String getTypePoolId(Widget widget) {
        AbstractWidgetLCA lca = WidgetUtil.getLCA((Widget)widget);
        return lca.getTypePoolId(widget);
    }

    private String getJSParentId(Widget widget) {
        String result = "";
        if (!(widget instanceof Shell) && widget instanceof Control) {
            Control control = (Control)widget;
            WidgetAdapter adapter = (WidgetAdapter)WidgetUtil.getAdapter((Widget)control);
            result = adapter.getJSParent() == null ? WidgetUtil.getId((Widget)control.getParent()) : adapter.getJSParent();
        }
        return result;
    }

    private void ensureWidgetManager() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        if (this.currentPhaseIsRender() && this.widget != null && stateInfo.getAttribute(HAS_WINDOW_MANAGER) == null) {
            this.writeVarAssignment(WIDGET_MANAGER_REF, "org.eclipse.swt.WidgetManager.getInstance()");
            stateInfo.setAttribute(HAS_WINDOW_MANAGER, (Object)Boolean.TRUE);
        }
    }

    private boolean currentPhaseIsRender() {
        return CurrentPhase.get() != null && CurrentPhase.get() != PhaseId.PROCESS_ACTION && CurrentPhase.get() != PhaseId.PREPARE_UI_ROOT && CurrentPhase.get() != PhaseId.READ_DATA;
    }

    private void ensureWidgetRef() throws IOException {
        this.ensureWidgetManager();
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Object currentWidgetRef = stateInfo.getAttribute(CURRENT_WIDGET_REF);
        if (this.widget != currentWidgetRef && this.widget != null) {
            this.writeVarAssignment(WIDGET_REF, JSWriter.createFindWidgetById(this.widget));
            JSWriter.setCurrentWidgetRef(this.widget);
        }
    }

    private static void setCurrentWidgetRef(Widget widget) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        stateInfo.setAttribute(CURRENT_WIDGET_REF, (Object)widget);
    }

    private static Widget getCurrentWidgetRef() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return (Widget)stateInfo.getAttribute(CURRENT_WIDGET_REF);
    }

    private static String createFindWidgetById(Widget widget) {
        return JSWriter.createFindWidgetById(WidgetUtil.getId((Widget)widget));
    }

    private static String createFindWidgetById(String id) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WIDGET_MANAGER_REF.toString());
        buffer.append(".findWidgetById( \"");
        buffer.append(id);
        buffer.append("\" )");
        return buffer.toString();
    }

    private static String createParamList(Object[] args) {
        return JSWriter.createParamList(" ", args, " ", true);
    }

    private static String createParamList(String startList, Object[] args, String endList, boolean useCurrentWidgetRef) {
        StringBuffer params = new StringBuffer();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i == 0) {
                    params.append(startList);
                }
                if (args[i] instanceof String) {
                    params.append('\"');
                    params.append(JSWriter.escapeString((String)args[i]));
                    params.append('\"');
                } else if (args[i] instanceof Character) {
                    params.append('\"');
                    params.append(args[i]);
                    params.append('\"');
                } else if (args[i] instanceof Widget) {
                    if (useCurrentWidgetRef && args[i] == JSWriter.getCurrentWidgetRef()) {
                        params.append("w");
                    } else {
                        params.append(JSWriter.createFindWidgetById((Widget)args[i]));
                    }
                } else if (args[i] instanceof JSVar) {
                    params.append(args[i]);
                } else if (args[i] instanceof Color) {
                    params.append('\"');
                    params.append(((IColor)args[i]).toColorValue());
                    params.append('\"');
                } else if (args[i] instanceof Object[]) {
                    params.append(JSWriter.createArray((Object[])args[i]));
                } else {
                    params.append(args[i]);
                }
                if (i == args.length - 1) {
                    params.append(endList);
                } else {
                    params.append(", ");
                }
                ++i;
            }
        }
        return params.toString();
    }

    private static String createArray(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(",");
            }
            if (array[i] instanceof String) {
                buffer.append(" \"");
                buffer.append(JSWriter.escapeString(array[i].toString()));
                buffer.append('\"');
            } else if (array[i] instanceof Widget) {
                buffer.append(JSWriter.createFindWidgetById((Widget)array[i]));
            } else if (array[i] instanceof Color) {
                buffer.append('\"');
                buffer.append(((IColor)array[i]).toColorValue());
                buffer.append('\"');
            } else {
                buffer.append(array[i]);
            }
            if (i == array.length - 1) {
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    private String createPropertyChain(String[] jsPropertyChain, boolean forReset) {
        StringBuffer buffer = new StringBuffer();
        int last = jsPropertyChain.length - 1;
        int i = 0;
        while (i < last) {
            buffer.append(JSWriter.getGetterName(jsPropertyChain[i]));
            buffer.append("().");
            ++i;
        }
        if (forReset) {
            buffer.append(JSWriter.getResetterName(jsPropertyChain[last]));
        } else {
            buffer.append(JSWriter.getSetterName(jsPropertyChain[last]));
        }
        return buffer.toString();
    }

    private static String capitalize(String text) {
        String result;
        if (Character.isUpperCase(text.charAt(0))) {
            result = text;
        } else {
            StringBuffer buffer = new StringBuffer(text);
            char firstLetter = buffer.charAt(0);
            firstLetter = Character.toUpperCase(firstLetter);
            buffer.setCharAt(0, firstLetter);
            result = buffer.toString();
        }
        return result;
    }

    private static String escapeString(String input) {
        String result = CommonPatterns.escapeDoubleQuoted((String)input);
        return CommonPatterns.replaceNewLines((String)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSetterName(String jsProperty) {
        Map map = setterNames;
        synchronized (map) {
            String result = (String)setterNames.get(jsProperty);
            if (result == null) {
                StringBuffer functionName = new StringBuffer();
                functionName.append("set");
                functionName.append(JSWriter.capitalize(jsProperty));
                result = functionName.toString();
                setterNames.put(jsProperty, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResetterName(String jsProperty) {
        Map map = resetterNames;
        synchronized (map) {
            String result = (String)resetterNames.get(jsProperty);
            if (result == null) {
                StringBuffer functionName = new StringBuffer();
                functionName.append("reset");
                functionName.append(JSWriter.capitalize(jsProperty));
                result = functionName.toString();
                resetterNames.put(jsProperty, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getGetterName(String jsProperty) {
        Map map = getterNames;
        synchronized (map) {
            String result = (String)getterNames.get(jsProperty);
            if (result == null) {
                StringBuffer functionName = new StringBuffer();
                functionName.append("get");
                functionName.append(JSWriter.capitalize(jsProperty));
                result = functionName.toString();
                getterNames.put(jsProperty, result);
            }
            return result;
        }
    }

    private void writeCall(JSVar target, String function, String params) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(target.toString());
        buffer.append('.');
        buffer.append(function);
        buffer.append('(');
        buffer.append(params);
        buffer.append(");");
        JSWriter.getWriter().write(buffer.toString());
    }

    private void writeVarAssignment(JSVar var, String value) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("var ");
        buffer.append(var.toString());
        buffer.append(" = ");
        buffer.append(value);
        buffer.append(';');
        JSWriter.getWriter().write(buffer.toString());
    }

    private static String format(String pattern, Object[] arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    private static void write(String pattern, Object arg1, Object arg2) throws IOException {
        Object[] args = new Object[]{arg1, arg2};
        JSWriter.getWriter().write(JSWriter.format(pattern, args));
    }

    private static void write(String pattern, Object arg1, Object arg2, Object arg3) throws IOException {
        Object[] args = new Object[]{arg1, arg2, arg3};
        JSWriter.getWriter().write(JSWriter.format(pattern, args));
    }

    private static HtmlResponseWriter getWriter() {
        return ContextProvider.getStateInfo().getResponseWriter();
    }
}

