/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.browser.browserkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class BrowserLCA
extends AbstractWidgetLCA {
    static final String BLANK_HTML = "<html><script></script></html>";
    private static final String QX_TYPE = "org.eclipse.swt.browser.Browser";
    private static final String QX_FIELD_SOURCE = "source";
    private static final String PARAM_EXECUTE_RESULT = "executeResult";
    private static final String PROP_URL = "url";
    private static final String PROP_TEXT = "text";
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        Browser browser = (Browser)widget;
        ControlLCAUtil.preserveValues((Control)browser);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)browser);
        adapter.preserve(PROP_URL, (Object)browser.getUrl());
        adapter.preserve(PROP_TEXT, (Object)BrowserLCA.getText(browser));
        WidgetLCAUtil.preserveCustomVariant((Widget)browser);
    }

    public void readData(Widget widget) {
        Browser browser = (Browser)widget;
        String value = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EXECUTE_RESULT);
        if (value != null) {
            boolean executeResult = Boolean.valueOf(value);
            BrowserLCA.getAdapter(browser).setExecuteResult(executeResult);
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)browser);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)browser);
    }

    public void renderChanges(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        ControlLCAUtil.writeChanges((Control)browser);
        BrowserLCA.writeUrl(browser);
        BrowserLCA.writeExecute(browser);
        WidgetLCAUtil.writeCustomVariant((Widget)browser);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(QX_FIELD_SOURCE);
        ControlLCAUtil.resetStyleFlags();
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeUrl(Browser browser) throws IOException {
        if (BrowserLCA.hasUrlChanged(browser)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.set(QX_FIELD_SOURCE, BrowserLCA.getUrl(browser));
        }
    }

    static boolean hasUrlChanged(Browser browser) {
        boolean initialized = WidgetUtil.getAdapter((Widget)browser).isInitialized();
        return !initialized || WidgetLCAUtil.hasChanged((Widget)browser, PROP_TEXT, BrowserLCA.getText(browser)) || WidgetLCAUtil.hasChanged((Widget)browser, PROP_URL, browser.getUrl());
    }

    static String getUrl(Browser browser) throws IOException {
        String text = BrowserLCA.getText(browser);
        String url = browser.getUrl();
        String result = text != null && !"".equals(text.trim()) ? BrowserLCA.registerHtml(text) : (url != null && !"".equals(url.trim()) ? url : BrowserLCA.registerHtml(BLANK_HTML));
        return result;
    }

    private static void writeExecute(Browser browser) throws IOException {
        IBrowserAdapter adapter = BrowserLCA.getAdapter(browser);
        String executeScript = adapter.getExecuteScript();
        if (executeScript != null) {
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.call("execute", new Object[]{executeScript});
        }
    }

    private static String registerHtml(String html) throws IOException {
        String name = BrowserLCA.createUrlFromHtml(html);
        byte[] bytes = html.getBytes("UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ResourceManager.getInstance().register(name, (InputStream)inputStream);
        return ResourceManager.getInstance().getLocation(name);
    }

    private static String createUrlFromHtml(String html) {
        StringBuffer result = new StringBuffer();
        result.append("org.eclipse.swt.browser/text");
        result.append(String.valueOf(html.hashCode()));
        result.append(".html");
        return result.toString();
    }

    private static String getText(Browser browser) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IBrowserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = browser.getAdapter((Class)clazz);
        IBrowserAdapter browserAdapter = (IBrowserAdapter)adapter;
        return browserAdapter.getText();
    }

    private static IBrowserAdapter getAdapter(Browser browser) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IBrowserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBrowserAdapter)browser.getAdapter((Class)clazz);
    }
}

