/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ccombokit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class CComboLCA
extends AbstractWidgetLCA {
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_SELECTION = new Integer(-1);
    private static final Integer DEFAULT_TEXT_LIMIT = new Integer(Integer.MAX_VALUE);
    private static final Point DEFAULT_TEXT_SELECTION = new Point(0, 0);
    private static final String JS_FUNC_SELECT = "select";
    private static final String JS_FUNC_SET_SELECTION_TEXT = "setTextSelection";
    static final String PROP_ITEMS = "items";
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION = "selection";
    static final String PROP_TEXT_SELECTION = "textSelection";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_LIST_VISIBLE = "listVisible";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_VERIFY_MODIFY_LISTENER = "verifyModifyListener";
    static final String PROP_MAX_LIST_HEIGHT = "maxListHeight";
    static final String PROP_LIST_ITEM_HEIGHT = "listItemHeight";

    public void preserveValues(Widget widget) {
        CCombo ccombo = (CCombo)widget;
        ControlLCAUtil.preserveValues((Control)ccombo);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        String[] items = ccombo.getItems();
        adapter.preserve(PROP_ITEMS, (Object)items);
        Integer selection = new Integer(ccombo.getSelectionIndex());
        adapter.preserve(PROP_SELECTION, (Object)selection);
        adapter.preserve(PROP_TEXT_SELECTION, (Object)ccombo.getSelection());
        adapter.preserve(PROP_TEXT_LIMIT, (Object)new Integer(ccombo.getTextLimit()));
        adapter.preserve(PROP_MAX_LIST_HEIGHT, (Object)new Integer(CComboLCA.getMaxListHeight(ccombo)));
        adapter.preserve(PROP_LIST_ITEM_HEIGHT, (Object)new Integer(ccombo.getItemHeight()));
        adapter.preserve(PROP_TEXT, (Object)ccombo.getText());
        adapter.preserve("selectionListeners", (Object)SelectionEvent.hasListener((Adaptable)ccombo));
        adapter.preserve(PROP_LIST_VISIBLE, (Object)new Boolean(ccombo.getListVisible()));
        adapter.preserve(PROP_EDITABLE, (Object)CComboLCA.isEditable(ccombo));
        boolean hasVerifyListener = VerifyEvent.hasListener((Adaptable)ccombo);
        boolean hasModifyListener = ModifyEvent.hasListener((Adaptable)ccombo);
        boolean hasListener = hasVerifyListener || hasModifyListener;
        adapter.preserve(PROP_VERIFY_MODIFY_LISTENER, (Object)hasListener);
        WidgetLCAUtil.preserveCustomVariant((Widget)ccombo);
    }

    public void readData(Widget widget) {
        String listVisible;
        CCombo ccombo = (CCombo)widget;
        String value = WidgetLCAUtil.readPropertyValue((Widget)ccombo, "selectedItem");
        if (value != null) {
            ccombo.select(Integer.parseInt(value));
        }
        if ((listVisible = WidgetLCAUtil.readPropertyValue((Widget)ccombo, PROP_LIST_VISIBLE)) != null) {
            ccombo.setListVisible(Boolean.valueOf(listVisible).booleanValue());
        }
        CComboLCA.readTextAndSelection(ccombo);
        ControlLCAUtil.processSelection((Widget)ccombo, null, true);
        ControlLCAUtil.processMouseEvents((Control)ccombo);
        ControlLCAUtil.processKeyEvents((Control)ccombo);
    }

    public void renderInitialization(Widget widget) throws IOException {
        CCombo ccombo = (CCombo)widget;
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.newWidget("org.eclipse.swt.widgets.Combo");
        ControlLCAUtil.writeStyleFlags((Control)ccombo);
        writer.call("addState", new Object[]{"rwt_CCOMBO"});
    }

    public void renderChanges(Widget widget) throws IOException {
        CCombo ccombo = (CCombo)widget;
        ControlLCAUtil.writeChanges((Control)ccombo);
        CComboLCA.writeListItemHeight(ccombo);
        CComboLCA.writeItems(ccombo);
        CComboLCA.writeSelection(ccombo);
        CComboLCA.writeMaxListHeight(ccombo);
        CComboLCA.writeEditable(ccombo);
        CComboLCA.writeText(ccombo);
        CComboLCA.writeTextSelection(ccombo);
        CComboLCA.writeListVisible(ccombo);
        CComboLCA.writeTextLimit(ccombo);
        CComboLCA.writeSelectionListener(ccombo);
        CComboLCA.writeVerifyAndModifyListener(ccombo);
        WidgetLCAUtil.writeCustomVariant((Widget)ccombo);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.call("removeAll", null);
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void readTextAndSelection(final CCombo ccombo) {
        final Point selection = CComboLCA.readSelection(ccombo);
        final String txt = WidgetLCAUtil.readPropertyValue((Widget)ccombo, PROP_TEXT);
        if (txt != null) {
            if (VerifyEvent.hasListener((Adaptable)ccombo)) {
                ProcessActionRunner.add((Runnable)new Runnable(){

                    public void run() {
                        ccombo.setText(txt);
                        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)ccombo);
                        adapter.preserve(CComboLCA.PROP_TEXT, (Object)txt);
                        if (selection != null) {
                            ccombo.setSelection(selection);
                            adapter.preserve(CComboLCA.PROP_TEXT_SELECTION, (Object)selection);
                        }
                    }
                });
            } else {
                ccombo.setText(txt);
                if (selection != null) {
                    ccombo.setSelection(selection);
                }
            }
        } else if (selection != null) {
            ccombo.setSelection(selection);
        }
    }

    private static Point readSelection(CCombo ccombo) {
        Point result = null;
        String selStart = WidgetLCAUtil.readPropertyValue((Widget)ccombo, "selectionStart");
        String selLength = WidgetLCAUtil.readPropertyValue((Widget)ccombo, "selectionLength");
        if (selStart != null || selLength != null) {
            result = new Point(0, 0);
            if (selStart != null) {
                result.x = Integer.parseInt(selStart);
            }
            if (selLength != null) {
                result.y = result.x + Integer.parseInt(selLength);
            }
        }
        return result;
    }

    private static void writeItems(CCombo ccombo) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
        String[] items = ccombo.getItems();
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_ITEMS, items, DEFAUT_ITEMS)) {
            int i = 0;
            while (i < items.length) {
                items[i] = WidgetLCAUtil.replaceNewLines(items[i], " ");
                items[i] = WidgetLCAUtil.escapeText(items[i], false);
                ++i;
            }
            writer.set(PROP_ITEMS, new Object[]{items});
        }
    }

    private static void writeSelection(CCombo ccombo) throws IOException {
        boolean textChanged;
        Integer newValue = new Integer(ccombo.getSelectionIndex());
        Integer defValue = DEFAULT_SELECTION;
        boolean selectionChanged = WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_SELECTION, newValue, defValue);
        boolean bl = textChanged = !CComboLCA.isEditable(ccombo) && WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_TEXT, ccombo.getText(), "");
        if (selectionChanged || textChanged) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.call(JS_FUNC_SELECT, new Object[]{newValue});
        }
    }

    private static void writeTextSelection(CCombo ccombo) throws IOException {
        Point newValue = ccombo.getSelection();
        Point defValue = DEFAULT_TEXT_SELECTION;
        Integer start = new Integer(newValue.x);
        Integer end = new Integer(newValue.y);
        Integer count = new Integer(end - start);
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_TEXT_SELECTION, newValue, defValue) && ccombo.isVisible()) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.call(JS_FUNC_SET_SELECTION_TEXT, new Object[]{start, count});
        }
    }

    private static void writeTextLimit(CCombo ccombo) throws IOException {
        Integer defValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
        Integer newValue = new Integer(ccombo.getTextLimit());
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_TEXT_LIMIT, newValue, defValue = DEFAULT_TEXT_LIMIT)) {
            if (newValue < 0) {
                newValue = null;
            }
            writer.set(PROP_TEXT_LIMIT, newValue);
        }
    }

    private static void writeListItemHeight(CCombo ccombo) throws IOException {
        Integer newValue = new Integer(ccombo.getItemHeight());
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_LIST_ITEM_HEIGHT, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.set(PROP_LIST_ITEM_HEIGHT, PROP_LIST_ITEM_HEIGHT, newValue);
        }
    }

    private static void writeMaxListHeight(CCombo ccombo) throws IOException {
        Integer newValue = new Integer(CComboLCA.getMaxListHeight(ccombo));
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_MAX_LIST_HEIGHT, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.set(PROP_MAX_LIST_HEIGHT, PROP_MAX_LIST_HEIGHT, newValue);
        }
    }

    private static void writeListVisible(CCombo ccombo) throws IOException {
        boolean listVisible = ccombo.getListVisible();
        Boolean newValue = listVisible;
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_LIST_VISIBLE, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.set(PROP_LIST_VISIBLE, PROP_LIST_VISIBLE, newValue, null);
        }
    }

    private static void writeEditable(CCombo ccombo) throws IOException {
        boolean editable = CComboLCA.isEditable(ccombo);
        Boolean newValue = editable;
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, PROP_EDITABLE, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.set(PROP_EDITABLE, PROP_EDITABLE, newValue, null);
        }
    }

    private static void writeText(CCombo ccombo) throws IOException {
        if (CComboLCA.isEditable(ccombo) || ccombo.getSelectionIndex() == -1) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.set(PROP_TEXT, "value", ccombo.getText(), "");
        }
    }

    private static void writeSelectionListener(CCombo ccombo) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = SelectionEvent.hasListener((Adaptable)ccombo);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.set("hasSelectionListener", ccombo);
        }
    }

    private static void writeVerifyAndModifyListener(CCombo ccombo) throws IOException {
        boolean hasVerifyListener = VerifyEvent.hasListener((Adaptable)ccombo);
        boolean hasModifyListener = ModifyEvent.hasListener((Adaptable)ccombo);
        String prop = PROP_VERIFY_MODIFY_LISTENER;
        boolean hasListener = hasVerifyListener || hasModifyListener;
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)ccombo, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)ccombo);
            writer.set("hasVerifyModifyListener", ccombo);
        }
    }

    private static boolean isEditable(CCombo ccombo) {
        return (ccombo.getStyle() & 8) == 0;
    }

    static int getMaxListHeight(CCombo ccombo) {
        int visibleItemCount = ccombo.getVisibleItemCount();
        int itemHeight = ccombo.getItemHeight();
        return visibleItemCount * itemHeight;
    }
}

