/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonDelegateLCA;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonLCAUtil;
import org.eclipse.swt.internal.widgets.buttonkit.CheckButtonDelegateLCA;
import org.eclipse.swt.internal.widgets.buttonkit.PushButtonDelegateLCA;
import org.eclipse.swt.internal.widgets.buttonkit.RadioButtonDelegateLCA;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class ButtonLCA
extends AbstractWidgetLCA {
    private static final Object[] NULL_PARAMETER = new Object[1];
    private static final ButtonDelegateLCA PUSH = new PushButtonDelegateLCA();
    private static final ButtonDelegateLCA CHECK = new CheckButtonDelegateLCA();
    private static final ButtonDelegateLCA RADIO = new RadioButtonDelegateLCA();

    public void preserveValues(Widget widget) {
        ButtonLCA.getLCADelegate(widget).preserveValues((Button)widget);
    }

    public void readData(Widget widget) {
        ButtonLCA.getLCADelegate(widget).readData((Button)widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ButtonLCA.getLCADelegate(widget).renderInitialization((Button)widget);
    }

    public void renderChanges(Widget widget) throws IOException {
        ButtonLCA.getLCADelegate(widget).renderChanges((Button)widget);
    }

    public void renderDispose(Widget widget) throws IOException {
        Button button = (Button)widget;
        Shell shell = button.getShell();
        if (!shell.isDisposed() && ButtonLCAUtil.isDefaultButton(button)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)button);
            writer.call((Widget)shell, "setDefaultButton", NULL_PARAMETER);
        }
        ButtonLCA.getLCADelegate(widget).renderDispose((Button)widget);
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        ButtonLCA.getLCADelegate(typePoolId).createResetHandlerCalls(typePoolId);
    }

    public String getTypePoolId(Widget widget) {
        return ButtonLCA.getLCADelegate(widget).getTypePoolId((Button)widget);
    }

    private static ButtonDelegateLCA getLCADelegate(String tpId) {
        ButtonDelegateLCA result;
        if (tpId.startsWith(CheckButtonDelegateLCA.TYPE_POOL_ID)) {
            result = CHECK;
        } else if (tpId.startsWith(PushButtonDelegateLCA.TYPE_POOL_ID)) {
            result = PUSH;
        } else if (tpId.startsWith(RadioButtonDelegateLCA.TYPE_POOL_ID)) {
            result = RADIO;
        } else {
            String txt = "The typePoolId ''{0}'' is not supported.";
            String msg = MessageFormat.format(txt, tpId);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    private static ButtonDelegateLCA getLCADelegate(Widget widget) {
        int style = ((Button)widget).getStyle();
        ButtonDelegateLCA result = (style & 0x20) != 0 ? CHECK : ((style & 8) != 0 ? PUSH : ((style & 0x10) != 0 ? RADIO : PUSH));
        return result;
    }
}

