/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tableitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ITableItemAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.tablekit.TableLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableItemLCA
extends AbstractWidgetLCA {
    static final String PROP_TEXTS = "texts";
    static final String PROP_IMAGES = "images";
    static final String PROP_CHECKED = "checked";
    static final String PROP_GRAYED = "grayed";
    static final String PROP_INDEX = "index";
    static final String PROP_SELECTED = "selected";
    static final String PROP_BACKGROUND = "background";
    static final String PROP_FOREGROUND = "foreground";
    static final String PROP_FONT = "font";
    static final String PROP_CELL_BACKGROUNDS = "cellBackgrounds";
    static final String PROP_CELL_FOREGROUNDS = "cellForegrounds";
    static final String PROP_CELL_FONTS = "cellFonts";
    static final String PROP_CACHED = "cached";
    static final String PROP_VARIANT = "variant";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void preserveValues(Widget widget) {
        TableItem item = (TableItem)widget;
        Table table = item.getParent();
        int index = item.getParent().indexOf(item);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)item);
        if (TableItemLCA.isCached(table, index)) {
            ItemLCAUtil.preserve((Item)item);
            if ((table.getStyle() & 0x20) != 0) {
                adapter.preserve(PROP_CHECKED, (Object)item.getChecked());
                adapter.preserve(PROP_GRAYED, (Object)item.getGrayed());
            }
            adapter.preserve(PROP_TEXTS, (Object)TableItemLCA.getTexts(item));
            adapter.preserve(PROP_IMAGES, (Object)TableItemLCA.getImages(item));
            adapter.preserve(PROP_INDEX, (Object)new Integer(index));
            adapter.preserve(PROP_SELECTED, (Object)TableItemLCA.isSelected(table, index));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object itemAdapter = item.getAdapter((Class)clazz);
            ITableItemAdapter tableItemAdapter = (ITableItemAdapter)itemAdapter;
            adapter.preserve(PROP_BACKGROUND, (Object)tableItemAdapter.getUserBackground());
            adapter.preserve(PROP_FOREGROUND, (Object)tableItemAdapter.getUserForeground());
            adapter.preserve(PROP_FONT, (Object)tableItemAdapter.getUserFont());
            adapter.preserve(PROP_CELL_BACKGROUNDS, (Object)tableItemAdapter.getCellBackgrounds());
            adapter.preserve(PROP_CELL_FOREGROUNDS, (Object)tableItemAdapter.getCellForegrounds());
            adapter.preserve(PROP_CELL_FONTS, (Object)tableItemAdapter.getCellFonts());
            adapter.preserve(PROP_VARIANT, (Object)WidgetUtil.getVariant((Widget)widget));
        }
        adapter.preserve(PROP_CACHED, (Object)TableItemLCA.isCached(table, index));
    }

    public void readData(Widget widget) {
        TableItem item = (TableItem)widget;
        this.readChecked(item);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TableItem item = (TableItem)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Table parent = item.getParent();
        int index = parent.indexOf(item);
        Object[] args = new Object[]{parent, new Integer(index)};
        writer.newWidget("org.eclipse.swt.widgets.TableItem", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        final TableItem item = (TableItem)widget;
        if (TableItemLCA.wasCleared(item)) {
            TableItemLCA.writeClear(item);
        } else {
            Table table = item.getParent();
            if (TableItemLCA.isCached(table, table.indexOf(item))) {
                TableItemLCA.preservingInitialized(item, new IRenderRunnable(){

                    public void run() throws IOException {
                        if (!TableItemLCA.wasCached(item)) {
                            TableItemLCA.setInitialized(item, false);
                        }
                        TableItemLCA.writeChanges(item);
                    }
                });
            }
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        TableItem item = (TableItem)widget;
        if (!item.getParent().isDisposed()) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.call("dispose", null);
        }
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private void readChecked(TableItem item) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)item, PROP_CHECKED);
        if (value != null) {
            item.setChecked(Boolean.valueOf(value).booleanValue());
        }
    }

    private static void writeChanges(TableItem item) throws IOException {
        boolean needUpdate = false;
        needUpdate |= TableItemLCA.writeTexts(item);
        needUpdate |= TableItemLCA.writeImages(item);
        needUpdate |= TableItemLCA.writeBackground(item);
        needUpdate |= TableItemLCA.writeForeground(item);
        needUpdate |= TableItemLCA.writeFont(item);
        needUpdate |= TableItemLCA.writeCellBackgrounds(item);
        needUpdate |= TableItemLCA.writeCellForegrounds(item);
        needUpdate |= TableItemLCA.writeCellFonts(item);
        needUpdate |= TableItemLCA.writeChecked(item);
        needUpdate |= TableItemLCA.writeGrayed(item);
        needUpdate |= TableItemLCA.writeSelection(item);
        needUpdate |= TableItemLCA.writeVariant(item);
        if (TableItemLCA.isVisible(item)) {
            Table table = item.getParent();
            needUpdate |= TableLCAUtil.hasAlignmentChanged(table);
            needUpdate |= TableItemLCA.hasIndexChanged(item);
        }
        if (needUpdate) {
            TableItemLCA.writeUpdate(item);
        }
        TableItemLCA.writeFocused(item);
    }

    private static void writeClear(TableItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.call("clear", null);
    }

    private static boolean writeTexts(TableItem item) throws IOException {
        String[] texts = TableItemLCA.getTexts(item);
        boolean result = WidgetLCAUtil.hasChanged((Widget)item, PROP_TEXTS, texts);
        if (result) {
            int i = 0;
            while (i < texts.length) {
                texts[i] = TableItemLCA.encodeHTML(item.getText(i));
                ++i;
            }
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_TEXTS, new Object[]{texts});
        }
        return result;
    }

    private static boolean writeImages(TableItem item) throws IOException {
        Image[] defValue;
        Image[] images = TableItemLCA.getImages(item);
        boolean result = WidgetLCAUtil.hasChanged((Widget)item, PROP_IMAGES, images, defValue = new Image[images.length]);
        if (result) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            String[] imagePaths = new String[images.length];
            int i = 0;
            while (i < imagePaths.length) {
                imagePaths[i] = ResourceFactory.getImagePath((Image)images[i]);
                ++i;
            }
            writer.set(PROP_IMAGES, new Object[]{imagePaths});
        }
        return result;
    }

    private static boolean writeBackground(TableItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        ITableItemAdapter tableItemAdapter = (ITableItemAdapter)adapter;
        Color background = tableItemAdapter.getUserBackground();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        return writer.set(PROP_BACKGROUND, PROP_BACKGROUND, background, null);
    }

    private static boolean writeForeground(TableItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        ITableItemAdapter tableItemAdapter = (ITableItemAdapter)adapter;
        Color foreground = tableItemAdapter.getUserForeground();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        return writer.set(PROP_FOREGROUND, PROP_FOREGROUND, foreground, null);
    }

    private static boolean writeFont(TableItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        ITableItemAdapter tableItemAdapter = (ITableItemAdapter)adapter;
        Font font = tableItemAdapter.getUserFont();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        String fontCss = font != null ? TableItemLCA.toCss(font) : null;
        return writer.set(PROP_FONT, PROP_FONT, fontCss, null);
    }

    private static boolean writeCellBackgrounds(TableItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        ITableItemAdapter tableItemAdapter = (ITableItemAdapter)adapter;
        Color[] backgrounds = tableItemAdapter.getCellBackgrounds();
        Color[] defValue = new Color[TableItemLCA.getColumnCount(item)];
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        return writer.set(PROP_CELL_BACKGROUNDS, PROP_CELL_BACKGROUNDS, backgrounds, defValue);
    }

    private static boolean writeCellForegrounds(TableItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        ITableItemAdapter tableItemAdapter = (ITableItemAdapter)adapter;
        Color[] foregrounds = tableItemAdapter.getCellForegrounds();
        Color[] defValue = new Color[TableItemLCA.getColumnCount(item)];
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        return writer.set(PROP_CELL_FOREGROUNDS, PROP_CELL_FOREGROUNDS, foregrounds, defValue);
    }

    private static boolean writeCellFonts(TableItem item) throws IOException {
        Font[] defValue;
        Object adapter;
        ITableItemAdapter tableItemAdapter;
        Font[] fonts;
        boolean result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (result = WidgetLCAUtil.hasChanged((Widget)item, PROP_CELL_FONTS, fonts = (tableItemAdapter = (ITableItemAdapter)(adapter = item.getAdapter((Class)clazz))).getCellFonts(), defValue = new Font[fonts.length])) {
            String[] css = new String[fonts.length];
            int i = 0;
            while (i < fonts.length) {
                css[i] = fonts[i] != null ? TableItemLCA.toCss(fonts[i]) : null;
                ++i;
            }
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_CELL_FONTS, new Object[]{css});
        }
        return result;
    }

    private static boolean writeChecked(TableItem item) throws IOException {
        boolean result;
        if ((item.getParent().getStyle() & 0x20) != 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            Boolean newValue = item.getChecked();
            result = writer.set(PROP_CHECKED, PROP_CHECKED, newValue, Boolean.FALSE);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean writeGrayed(TableItem item) throws IOException {
        boolean result;
        if ((item.getParent().getStyle() & 0x20) != 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            Boolean newValue = item.getGrayed();
            result = writer.set(PROP_GRAYED, PROP_GRAYED, newValue, Boolean.FALSE);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean writeSelection(TableItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = TableItemLCA.isSelected(item);
        return writer.set(PROP_SELECTED, "selection", newValue, Boolean.FALSE);
    }

    private static void writeFocused(TableItem item) throws IOException {
        if (TableLCAUtil.hasFocusIndexChanged(item.getParent()) && TableItemLCA.isFocused(item)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            int index = TableItemLCA.getTableAdapter(item).getFocusIndex();
            Object[] args = new Object[]{new Integer(index)};
            writer.call((Widget)item.getParent(), "setFocusIndex", args);
        }
    }

    private static boolean writeVariant(TableItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        String variant = WidgetUtil.getVariant((Widget)item);
        boolean result = WidgetLCAUtil.hasChanged((Widget)item, PROP_VARIANT, variant, null);
        if (result) {
            Object[] args = new Object[]{"variant_" + variant};
            writer.set(PROP_VARIANT, args);
        }
        return result;
    }

    private static void writeUpdate(TableItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.call("update", null);
    }

    private static String encodeHTML(String text) {
        String result = text.replaceAll("&", "&#038;");
        result = result.replaceAll("\"", "&#034;");
        result = result.replaceAll(">", "&#062;");
        result = result.replaceAll("<", "&#060;");
        return result;
    }

    private static String toCss(Font font) {
        StringBuffer result = new StringBuffer();
        FontData fontData = font.getFontData()[0];
        if ((fontData.getStyle() & 2) != 0) {
            result.append("italic ");
        }
        if ((fontData.getStyle() & 1) != 0) {
            result.append("bold ");
        }
        result.append(fontData.getHeight());
        result.append("px ");
        String escapedName = fontData.getName().replaceAll("\"", "");
        result.append(escapedName);
        return result.toString();
    }

    private static boolean hasIndexChanged(TableItem item) {
        int index = item.getParent().indexOf(item);
        return WidgetLCAUtil.hasChanged((Widget)item, PROP_INDEX, new Integer(index));
    }

    static String[] getTexts(TableItem item) {
        int columnCount = TableItemLCA.getColumnCount(item);
        String[] result = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = item.getText(i);
            ++i;
        }
        return result;
    }

    static Image[] getImages(TableItem item) {
        int columnCount = TableItemLCA.getColumnCount(item);
        Image[] result = new Image[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = item.getImage(i);
            ++i;
        }
        return result;
    }

    private static int getColumnCount(TableItem item) {
        return Math.max(1, item.getParent().getColumnCount());
    }

    private static boolean isSelected(TableItem item) {
        Table table = item.getParent();
        int index = table.indexOf(item);
        return TableItemLCA.isSelected(table, index);
    }

    private static boolean isSelected(Table table, int itemIndex) {
        return itemIndex != -1 && table.isSelected(itemIndex);
    }

    private static boolean isFocused(TableItem item) {
        int focusIndex = TableItemLCA.getTableAdapter(item).getFocusIndex();
        return focusIndex != -1 && item == item.getParent().getItem(focusIndex);
    }

    private static boolean isVisible(TableItem item) {
        return TableItemLCA.getTableAdapter(item).isItemVisible(item);
    }

    private static boolean wasCleared(TableItem item) {
        Table table = item.getParent();
        boolean cached = TableItemLCA.isCached(table, table.indexOf(item));
        boolean wasCached = TableItemLCA.wasCached(item);
        return !cached && wasCached;
    }

    private static boolean isCached(Table table, int index) {
        ITableAdapter adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return !(adapter = (ITableAdapter)table.getAdapter((Class)clazz)).isItemVirtual(index);
    }

    private static boolean wasCached(TableItem item) {
        boolean wasCached;
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)item);
        if (adapter.isInitialized()) {
            Boolean preserved = (Boolean)adapter.getPreserved(PROP_CACHED);
            wasCached = Boolean.TRUE.equals(preserved);
        } else {
            wasCached = true;
        }
        return wasCached;
    }

    private static ITableAdapter getTableAdapter(TableItem item) {
        Table table = item.getParent();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITableAdapter)table.getAdapter((Class)clazz);
    }

    private static void preservingInitialized(TableItem item, IRenderRunnable runnable) throws IOException {
        boolean initialized = WidgetUtil.getAdapter((Widget)item).isInitialized();
        runnable.run();
        TableItemLCA.setInitialized(item, initialized);
    }

    private static void setInitialized(TableItem item, boolean initialized) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rwt.lifecycle.IWidgetAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WidgetAdapter adapter = (WidgetAdapter)item.getAdapter((Class)clazz);
        adapter.setInitialized(initialized);
    }

    private static interface IRenderRunnable {
        public void run() throws IOException;
    }
}

