/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.tablekit.TableLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableLCA
extends AbstractWidgetLCA {
    static final String PROP_HEADER_HEIGHT = "headerHeight";
    static final String PROP_HEADER_VISIBLE = "headerVisible";
    static final String PROP_LINES_VISIBLE = "linesVisible";
    static final String PROP_ITEM_HEIGHT = "itemHeight";
    static final String PROP_TOP_INDEX = "topIndex";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    static final String PROP_DEFAULT_COLUMN_WIDTH = "defaultColumnWidth";
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_HIDE_SELECTION = "hideSelection";
    static final String PROP_HAS_H_SCROLL_BAR = "hasHScrollBar";
    static final String PROP_HAS_V_SCROLL_BAR = "hasVScrollBar";
    private static final Integer DEFAULT_TOP_INDEX = new Integer(0);
    private static final Integer DEFAULT_ITEM_COUNT = new Integer(0);
    private static final Integer DEFAUT_ITEM_HEIGHT = new Integer(0);
    private static final Integer DEFAULT_DEFAULT_COLUMN_WIDTH = new Integer(0);
    private static final JSListenerInfo SELECTION_LISTENER = new JSListenerInfo("itemselected", "this.onItemSelected", JSListenerType.ACTION);
    private static final JSListenerInfo DEFAULT_SELECTION_LISTENER = new JSListenerInfo("itemdefaultselected", "this.onItemDefaultSelected", JSListenerType.ACTION);
    private static final JSListenerInfo CHECK_SELECTION_LISTENER = new JSListenerInfo("itemchecked", "this.onItemChecked", JSListenerType.ACTION);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        Table table = (Table)widget;
        ControlLCAUtil.preserveValues((Control)table);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)table);
        adapter.preserve(PROP_HEADER_HEIGHT, (Object)new Integer(table.getHeaderHeight()));
        adapter.preserve(PROP_HEADER_VISIBLE, (Object)table.getHeaderVisible());
        adapter.preserve(PROP_LINES_VISIBLE, (Object)table.getLinesVisible());
        adapter.preserve(PROP_ITEM_HEIGHT, (Object)new Integer(table.getItemHeight()));
        TableLCAUtil.preserveItemMetrics(table);
        adapter.preserve(PROP_ITEM_COUNT, (Object)new Integer(table.getItemCount()));
        adapter.preserve(PROP_TOP_INDEX, (Object)new Integer(table.getTopIndex()));
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)SelectionEvent.hasListener((Adaptable)table));
        adapter.preserve(PROP_DEFAULT_COLUMN_WIDTH, (Object)new Integer(TableLCA.getDefaultColumnWidth(table)));
        TableLCAUtil.preserveFocusIndex(table);
        WidgetLCAUtil.preserveCustomVariant((Widget)table);
        adapter.preserve(PROP_HIDE_SELECTION, (Object)TableLCA.hideSelection(table));
        adapter.preserve(PROP_HAS_H_SCROLL_BAR, (Object)this.hasHScrollBar(table));
        adapter.preserve(PROP_HAS_V_SCROLL_BAR, (Object)this.hasVScrollBar(table));
    }

    public void readData(Widget widget) {
        Table table = (Table)widget;
        TableLCA.readTopIndex(table);
        TableLCA.readLeftOffset(table);
        TableLCA.readSelection(table);
        TableLCA.readFocusIndex(table);
        TableLCA.readSetData(table);
        TableLCA.readWidgetSelected(table);
        TableLCA.readWidgetDefaultSelected(table);
        ControlLCAUtil.processMouseEvents((Control)table);
        ControlLCAUtil.processKeyEvents((Control)table);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Table table = (Table)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        String style = "";
        if ((table.getStyle() & 0x20) != 0) {
            style = "check";
        }
        if ((table.getStyle() & 2) != 0) {
            style = String.valueOf(style) + "|multi";
        }
        Object[] args = new Object[]{WidgetUtil.getId((Widget)table), style};
        writer.newWidget("org.eclipse.swt.widgets.Table", args);
        ControlLCAUtil.writeStyleFlags((Control)table);
        writer.set("borderWidth", table.getBorderWidth());
    }

    public void renderChanges(Widget widget) throws IOException {
        Table table = (Table)widget;
        ControlLCAUtil.writeChanges((Control)table);
        TableLCA.writeHeaderHeight(table);
        TableLCA.writeHeaderVisible(table);
        TableLCA.writeItemHeight(table);
        TableLCAUtil.writeItemMetrics(table);
        TableLCA.writeItemCount(table);
        TableLCA.writeTopIndex(table);
        TableLCA.writeFocusIndex(table);
        TableLCA.writeLinesVisible(table);
        TableLCA.writeSelectionListener(table);
        TableLCA.writeDefaultColumnWidth(table);
        this.writeHideSelection(table);
        this.writeScrollBarsVisible(table);
        WidgetLCAUtil.writeCustomVariant((Widget)table);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    public void doRedrawFake(Control control) {
        Table table = (Table)control;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        tableAdapter.checkData();
    }

    private static void readSelection(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, "selection");
        if (value != null) {
            int[] newSelection;
            if ("".equals(value)) {
                newSelection = new int[]{};
            } else {
                String[] selectedIndices = value.split(",");
                newSelection = new int[selectedIndices.length];
                int i = 0;
                while (i < selectedIndices.length) {
                    newSelection[i] = Integer.parseInt(selectedIndices[i]);
                    ++i;
                }
            }
            table.deselectAll();
            table.select(newSelection);
        }
    }

    private static void readTopIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, PROP_TOP_INDEX);
        if (value != null) {
            table.setTopIndex(Integer.parseInt(value));
        }
    }

    private static void readFocusIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, "focusIndex");
        if (value != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITableAdapter adapter = (ITableAdapter)table.getAdapter((Class)clazz);
            adapter.setFocusIndex(Integer.parseInt(value));
        }
    }

    private static void readLeftOffset(Table table) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)table, "leftOffset");
        if (value != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = table.getAdapter((Class)clazz);
            ITableAdapter tableAdapter = (ITableAdapter)adapter;
            tableAdapter.setLeftOffset(Integer.parseInt(value));
        }
    }

    private static void readSetData(Table table) {
        if (WidgetLCAUtil.wasEventSent((Widget)table, "org.eclipse.swt.events.setData")) {
            HttpServletRequest request = ContextProvider.getRequest();
            String value = request.getParameter("org.eclipse.swt.events.setData.index");
            String[] indices = value.split(",");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = table.getAdapter((Class)clazz);
            ITableAdapter tableAdapter = (ITableAdapter)adapter;
            int i = 0;
            while (i < indices.length) {
                int index = Integer.parseInt(indices[i]);
                if (index > -1 && index < table.getItemCount()) {
                    tableAdapter.checkData(index);
                }
                ++i;
            }
        }
    }

    private static void readWidgetSelected(Table table) {
        int index;
        if (WidgetLCAUtil.wasEventSent((Widget)table, "org.eclipse.swt.events.widgetSelected") && (index = TableLCA.getWidgetSelectedIndex()) > -1 && index < table.getItemCount()) {
            TableItem item = table.getItem(index);
            int detail = TableLCA.getWidgetSelectedDetail();
            int id = 13;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            SelectionEvent event = new SelectionEvent((Widget)table, (Widget)item, id, bounds, "", true, detail);
            event.processEvent();
        }
    }

    private static void readWidgetDefaultSelected(Table table) {
        String defaultSelectedParam = "org.eclipse.swt.events.widgetDefaultSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)table, defaultSelectedParam)) {
            TableItem item = TableLCA.getFocusedItem(table);
            int selectedIndex = TableLCA.getWidgetSelectedIndex();
            if (selectedIndex != -1) {
                item = table.getItem(selectedIndex);
            }
            int id = 14;
            SelectionEvent event = new SelectionEvent((Widget)table, (Widget)item, id);
            event.processEvent();
        }
    }

    private static int getWidgetSelectedDetail() {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter("org.eclipse.swt.events.widgetSelected.detail");
        return "check".equals(value) ? 32 : 0;
    }

    private static int getWidgetSelectedIndex() {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter("org.eclipse.swt.events.widgetSelected.index");
        return Integer.parseInt(value);
    }

    private static TableItem getFocusedItem(Table table) {
        ITableAdapter tableAdapter;
        int focusIndex;
        TableItem result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((focusIndex = (tableAdapter = (ITableAdapter)table.getAdapter((Class)clazz)).getFocusIndex()) != -1) {
            result = table.getItem(focusIndex);
        }
        return result;
    }

    private static void writeHeaderHeight(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getHeaderHeight());
        writer.set(PROP_HEADER_HEIGHT, PROP_HEADER_HEIGHT, newValue, null);
    }

    private static void writeHeaderVisible(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Boolean newValue = table.getHeaderVisible();
        writer.set(PROP_HEADER_VISIBLE, PROP_HEADER_VISIBLE, newValue, null);
    }

    private static void writeItemHeight(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getItemHeight());
        writer.set(PROP_ITEM_HEIGHT, PROP_ITEM_HEIGHT, newValue, DEFAUT_ITEM_HEIGHT);
    }

    private static void writeItemCount(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getItemCount());
        writer.set(PROP_ITEM_COUNT, PROP_ITEM_COUNT, newValue, DEFAULT_ITEM_COUNT);
    }

    private static void writeTopIndex(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Integer newValue = new Integer(table.getTopIndex());
        writer.set(PROP_TOP_INDEX, PROP_TOP_INDEX, newValue, DEFAULT_TOP_INDEX);
    }

    private static void writeFocusIndex(Table table) throws IOException {
        if (TableLCAUtil.hasFocusIndexChanged(table)) {
            ITableAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ITableAdapter)table.getAdapter((Class)clazz)).getFocusIndex() == -1) {
                JSWriter writer = JSWriter.getWriterFor((Widget)table);
                writer.set("focusIndex", new Object[]{new Integer(-1)});
            }
        }
    }

    private static void writeLinesVisible(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Boolean newValue = table.getLinesVisible();
        writer.set(PROP_LINES_VISIBLE, PROP_LINES_VISIBLE, newValue, Boolean.FALSE);
    }

    private static void writeSelectionListener(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        writer.updateListener(SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)table));
        writer.updateListener(DEFAULT_SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)table));
        if ((table.getStyle() & 0x20) != 0) {
            writer.updateListener(CHECK_SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)table));
        }
    }

    private static void writeDefaultColumnWidth(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        String prop = PROP_DEFAULT_COLUMN_WIDTH;
        Integer newValue = new Integer(TableLCA.getDefaultColumnWidth(table));
        Integer defValue = DEFAULT_DEFAULT_COLUMN_WIDTH;
        writer.set(prop, PROP_DEFAULT_COLUMN_WIDTH, newValue, defValue);
    }

    private void writeHideSelection(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)table);
        Boolean newValue = TableLCA.hideSelection(table);
        Boolean defValue = Boolean.FALSE;
        writer.set(PROP_HIDE_SELECTION, PROP_HIDE_SELECTION, newValue, defValue);
    }

    private void writeScrollBarsVisible(Table table) throws IOException {
        boolean hasHChanged = WidgetLCAUtil.hasChanged((Widget)table, PROP_HAS_H_SCROLL_BAR, this.hasHScrollBar(table), Boolean.TRUE);
        boolean hasVChanged = WidgetLCAUtil.hasChanged((Widget)table, PROP_HAS_V_SCROLL_BAR, this.hasVScrollBar(table), Boolean.TRUE);
        if (hasHChanged || hasVChanged) {
            JSWriter writer = JSWriter.getWriterFor((Widget)table);
            Object[] args = new Object[]{this.hasHScrollBar(table), this.hasVScrollBar(table)};
            writer.call("setScrollBarsVisibile", args);
        }
    }

    private Boolean hasHScrollBar(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        return tableAdapter.hasHScrollBar();
    }

    private Boolean hasVScrollBar(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        return tableAdapter.hasVScrollBar();
    }

    static int getDefaultColumnWidth(Table table) {
        int result = 0;
        if (table.getColumnCount() == 0) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = table.getAdapter((Class)clazz);
            ITableAdapter tableAdapter = (ITableAdapter)adapter;
            result = tableAdapter.getDefaultColumnWidth();
        }
        return result;
    }

    static Boolean hideSelection(Table table) {
        Boolean result = Boolean.FALSE;
        Object data = table.getData(Table.HIDE_SELECTION);
        if (Boolean.TRUE.equals(data)) {
            result = Boolean.TRUE;
        }
        return result;
    }
}

