/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemDelegateLCA;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class RadioToolItemLCA
extends ToolItemDelegateLCA {
    private static final String CREATE_RADIO = "org.eclipse.swt.ToolItemUtil.createRadio";
    private static final String WIDGET_SELECTED = "org.eclipse.swt.ButtonUtil.radioSelected";
    private final JSListenerInfo JS_LISTENER_INFO = new JSListenerInfo("changeSelected", "org.eclipse.swt.ButtonUtil.radioSelected", JSListenerType.STATE_AND_ACTION);

    RadioToolItemLCA() {
    }

    void preserveValues(ToolItem toolItem) {
        ToolItemLCAUtil.preserveValues(toolItem);
        ToolItemLCAUtil.preserveImages(toolItem);
        ToolItemLCAUtil.preserveSelection(toolItem);
        WidgetLCAUtil.preserveCustomVariant((Widget)toolItem);
    }

    void readData(ToolItem toolItem) {
        if (WidgetLCAUtil.wasEventSent((Widget)toolItem, "org.eclipse.swt.events.widgetSelected")) {
            ToolItem[] items = toolItem.getParent().getItems();
            int i = 0;
            while (i < items.length) {
                if ((items[i].getStyle() & 0x10) != 0) {
                    items[i].setSelection(false);
                }
                ++i;
            }
            toolItem.setSelection(true);
            ToolItemLCAUtil.processSelection(toolItem);
        }
    }

    void renderInitialization(ToolItem toolItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        ToolBar bar = toolItem.getParent();
        int myIndex = bar.indexOf(toolItem);
        ToolItem neighbour = null;
        if (myIndex > 0 && ((neighbour = bar.getItem(myIndex - 1)).getStyle() & 0x10) == 0) {
            neighbour = null;
        }
        Object[] args = new Object[]{WidgetUtil.getId((Widget)toolItem), toolItem.getParent(), toolItem.getSelection() ? "true" : null, neighbour};
        writer.callStatic(CREATE_RADIO, args);
        if ((toolItem.getParent().getStyle() & 0x800000) != 0) {
            writer.call("addState", new Object[]{"rwt_FLAT"});
        }
    }

    void renderChanges(ToolItem toolItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        ItemLCAUtil.writeText((Item)toolItem, false);
        ToolItemLCAUtil.writeImages(toolItem);
        WidgetLCAUtil.writeToolTip((Widget)toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.writeEnabled((Widget)toolItem, toolItem.getEnabled());
        ToolItemLCAUtil.writeVisible(toolItem);
        ToolItemLCAUtil.writeBounds(toolItem);
        ToolItemLCAUtil.writeSelection(toolItem, toolItem.getSelection());
        WidgetLCAUtil.writeMenu((Widget)toolItem, toolItem.getParent().getMenu());
        writer.updateListener("manager", this.JS_LISTENER_INFO, "selectionListeners", SelectionEvent.hasListener((Adaptable)toolItem));
        WidgetLCAUtil.writeCustomVariant((Widget)toolItem);
    }
}

