/*******************************************************************************
 * Copyright (c) 2002, 2007 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/
package org.eclipse.rwt.internal.util;


/**
 * <p>
 * 'Static' class which provides commonly used constants used to generate markup.
 * </p> 
 */
public final class HTML {
  public final static String AJAX_RESPONSE = "ajax-response";
  public final static String START_AJAX_RESPONSE = "<ajax-response>";
  public final static String END_AJAX_RESPONSE = "</ajax-response>";
  
  public final static String NBSP_STRING = "\u00A0";
  public final static char NBSP_CHAR = '\u00A0';
  
  public final static String A = "a";
  public final static String ACCEPT_CHARSET = "accept-charset";
  public final static String ACTION = "action";
  public final static String ALIGN = "align";
  public final static String ALT = "alt";
  public final static String BACKGROUND = "background";
  public final static String BGCOLOR = "bgcolor";
  public final static String BODY = "body";
  public final static String BOLD = "b";
  public final static String BORDER = "border";
  public final static String BR = "br";
  public final static String BUTTON = "button";
  public final static String CELLPADDING = "cellpadding";
  public final static String CELLSPACING = "cellspacing";
  public final static String CHARSET = "charset";
  public final static String CHECKBOX = "checkbox";
  public final static String CHECKED = "checked";
  public final static String CENTER = "center";
  public final static String COLOR = "color";
  public final static String COLS = "cols";
  public final static String COLSPAN = "colspan";
  public final static String CONTENT = "content";
  public final static String CONTENT_TYPE = "Content-Type";
  public final static String CLASS = "class";
  public final static String DIR = "dir";
  public final static String DISABLED = "disabled";
  public final static String DIV = "div";
  public final static String ENCTYPE = "enctype";
  public final static String FACE = "face";
  public final static String FILE = "file";
  public final static String FONT = "font";
  public final static String FORM = "form";
  public final static String H3 = "h3";
  public final static String HEAD = "head";
  public final static String HEIGHT = "height";
  public final static String HIDDEN = "hidden";
  public final static String HIDE = "hide";
  public final static String HREF = "href";
  public final static String HTML = "html";
  public final static String HTTP_EQUIV = "http-equiv";
  public final static String ID = "id";
  public final static String IMG = "img";
  public final static String IMAGE = "image";
  public final static String INPUT = "input";
  public final static String LABEL = "label";
  public final static String LANGUAGE = "language";
  public final static String LANG = "lang";
  public final static String LAYER = "layer";
  public final static String LEFT = "left";
  public final static String LEFTMARGIN = "leftmargin";
  public final static String LI = "li";
  public final static String LINK = "link";
  public final static String MARGINHEIGHT = "marginheight";
  public final static String MARGINWIDTH = "marginwidth";
  public final static String MAXLENGTH = "maxlength";
  public final static String META = "meta";
  public final static String METHOD = "method";
  public final static String MIDDLE = "middle";
  public final static String NAME = "name";
  public final static String NBSP = "&nbsp;";
  public final static String NOWRAP = "nowrap";
  public final static String OL = "ol";
  public final static String ON_CHANGE = "onchange";
  public final static String ON_CLICK = "onclick";
  public final static String ON_DBL_CLICK = "ondblclick";
  public final static String ON_FOCUS = "onfocus";
  public final static String ON_KEY_DOWN = "onkeydown";
  public final static String ON_KEY_UP = "onkeyup";
  public final static String ON_KEY_PRESS = "onkeypress";
  public final static String ON_MOUSE_DOWN = "onmousedown";
  public final static String ON_MOUSE_MOVE = "onmousemove";
  public final static String ON_MOUSE_OVER = "onmouseover";
  public final static String ON_MOUSE_OUT = "onmouseout";
  public final static String ON_MOUSE_UP = "onmouseup";
  public final static String ON_RESIZE = "onresize";
  public final static String ON_UNLOAD = "onunload";
  public final static String OPTION = "option";
  public final static String OVERFLOW = "overflow";
  public final static String P = "p";
  public final static String PASSWORD = "password";
  public final static String POST = "post";
  public final static String POSITION = "position";
  public final static String RADIO = "radio";
  public final static String READONLY = "readonly";
  public final static String REL = "rel";
  public final static String RESET = "reset";
  public final static String ROWS = "rows";
  public final static String ROWSPAN = "rowspan";
  public final static String SCRIPT = "script";
  public final static String SELECT = "select";
  public final static String SELECTED = "selected";
  public final static String SIZE = "size";
  public final static String SPAN = "span";
  public final static String SRC = "src";
  public final static String START = "start";
  public final static String STYLE = "style";
  public final static String STYLESHEET = "stylesheet";
  public final static String SUBMIT = "submit";
  public final static String TABINDEX = "tabindex";
  public final static String TABLE = "table";
  public final static String TARGET = "target";
  public final static String TD = "td";
  public final static String TEXT = "text";
  public final static String TEXTAREA = "textarea";
  public final static String TITLE = "title";
  public final static String TOP = "top";
  public final static String TOPMARGIN = "topmargin";
  public final static String TR = "tr";
  public final static String TYPE = "type";
  public final static String UL = "ul";
  public final static String VALIGN = "valign";
  public final static String VALUE = "value";
  public final static String WIDTH = "width";
  public final static String VISIBILITY = "visibility";
  public final static String WRAP = "wrap";
  
  public final static String TAG_BEGIN_OPEN = "<";
  public final static String TAG_END_OPEN = "</";
  public final static String TAG_CLOSE = ">";

  public final static String DOCTYPE_4_0_TRANSITIONAL
    = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
  public final static String DOCTYPE_4_01_TRANSITIONAL 
    = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";

  public final static String CONTENT_TEXT_HTML_UTF_8 
    = "text/html; charset=UTF-8";
  public final static String CONTENT_TEXT_HTML = "text/html";
  public final static String CONTENT_TEXT_XML = "text/xml";
  public final static String CONTENT_TEXT_CSS = "text/css";
  public final static String CONTENT_TEXT_JAVASCRIPT = "text/javascript";
  public final static String CONTENT_TEXT_JAVASCRIPT_UTF_8 
    = "text/javascript; charset=UTF-8";
  public final static String CONTENT_IMAGE_ICO = "image/ico";
  public final static String CONTENT_IMAGE_GIF = "image/gif";

  public final static String ENCTYPE_FORM_URLENCODED 
    = "application/x-www-form-urlencoded";
  public final static String ENCTYPE_FORM_DATA = "multipart/form-data";

  public final static String CHARSET_NAME_UTF_8 = "UTF-8";
  public final static String CHARSET_NAME_ISO_8859_1 = "ISO-8859-1";
  
  public final static String CONTENT_ENCODING = "Content-Encoding";
  public final static String ENCODING_GZIP = "gzip";
  public final static String ACCEPT_ENCODING = "Accept-Encoding";
  public static final String EXPIRES = "Expires";
  
  private HTML() {
    // prevent instantiation
  }
}