/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.browser;

import java.lang.reflect.Constructor;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.browser.Browser;
import org.eclipse.rwt.internal.browser.BrowserDetector;
import org.eclipse.rwt.internal.browser.Default;
import org.eclipse.rwt.internal.service.ContextProvider;

public final class BrowserLoader {
    public static final String USER_AGENT = "User-Agent";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Browser load() {
        String browserClassName = BrowserLoader.detectBrowserClassName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.browser.Default");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Browser result = browserClassName.equals(clazz.getName()) ? new Default(false) : BrowserLoader.loadClassForName(browserClassName, BrowserLoader.isScriptEnabled(), BrowserLoader.isAjaxEnabled());
        return result;
    }

    public static Browser loadClassForName(String browserClassName, boolean scriptEnabled, boolean ajaxEnabled) {
        Browser result;
        try {
            Class<?> clazz = Class.forName(browserClassName);
            Class[] types = new Class[]{Boolean.TYPE, Boolean.TYPE};
            Constructor<?> constructor = clazz.getConstructor(types);
            Object[] params = new Object[]{scriptEnabled, ajaxEnabled};
            result = (Browser)constructor.newInstance(params);
        }
        catch (Exception exception) {
            System.out.println(BrowserLoader.createMessage(browserClassName));
            result = new Default(scriptEnabled, ajaxEnabled);
        }
        return result;
    }

    public static Browser loadClassForName(String browserClassName, Browser browser) {
        Browser result = null;
        try {
            Class<?> clazz = Class.forName(browserClassName);
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.rwt.internal.browser.Browser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class[] types = classArray;
            Constructor<?> constructor = clazz.getConstructor(types);
            Object[] params = new Object[]{browser};
            result = (Browser)constructor.newInstance(params);
        }
        catch (Exception exception) {
            System.out.println(BrowserLoader.createMessage(browserClassName));
            result = BrowserLoader.loadDefaultBrowser(browser);
        }
        return result;
    }

    private static String createMessage(String browserClassName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String userAgent = request.getHeader(USER_AGENT);
        StringBuffer result = new StringBuffer();
        result.append(new Date());
        result.append(" BROWSERLOADER: Browser instantiation fault.\n");
        result.append("Could not load a valid org.eclipse.rap.Browser ");
        result.append("subclass for the received name '");
        result.append(browserClassName);
        result.append("'. Switch to default Browser.\n");
        result.append("User-Agent: ");
        result.append(userAgent);
        return result.toString();
    }

    private static String detectBrowserClassName() {
        String userAgent = ContextProvider.getRequest().getHeader(USER_AGENT);
        BrowserDetector detector = BrowserDetector.getInstance();
        return detector.getBrowserClassName(userAgent);
    }

    private static boolean isScriptEnabled() {
        HttpServletRequest request = ContextProvider.getRequest();
        return "true".equals(request.getParameter("w4t_scriptEnabled"));
    }

    private static boolean isAjaxEnabled() {
        HttpServletRequest request = ContextProvider.getRequest();
        return "true".equals(request.getParameter("w4t_ajaxEnabled"));
    }

    private static Browser loadDefaultBrowser(Browser browser) {
        return new Default(browser.isScriptEnabled(), browser.isAjaxEnabled());
    }

    private BrowserLoader() {
    }
}

