/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.ServiceStateInfo;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.service.ISessionStore;

final class UIThread
extends Thread
implements IUIThreadHolder,
ISessionShutdownAdapter {
    private ServiceContext serviceContext;
    private ISessionStore sessionStore;
    private Runnable shutdownCallback;

    public UIThread(Runnable runnable) {
        super(runnable);
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void updateServiceContext() {
        if (ContextProvider.hasContext()) {
            ContextProvider.releaseContextHolder();
        }
        ContextProvider.setContext(this.serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchThread() throws InterruptedException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            lock.notifyAll();
            lock.wait();
        }
    }

    public void terminateThread() {
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Thread getThread() {
        return this;
    }

    public Object getLock() {
        return this;
    }

    public void setSessionStore(ISessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public void setShutdownCallback(Runnable shutdownCallback) {
        this.shutdownCallback = shutdownCallback;
    }

    public void interceptShutdown() {
        ServiceContext serviceContext = UICallBackServiceHandler.getFakeContext(this.sessionStore);
        serviceContext.setStateInfo(new ServiceStateInfo());
        this.setServiceContext(serviceContext);
        this.terminateThread();
    }

    public void processShutdown() {
        this.updateServiceContext();
        CurrentPhase.set(PhaseId.PROCESS_ACTION);
        this.shutdownCallback.run();
        ContextProvider.disposeContext();
    }
}

