/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.service.IServiceHandler;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ServiceManager {
    private static final String SERVICEHANDLER_XML = "servicehandler.xml";
    private static IServiceHandler lifeCycleRequestHandler;
    private static IServiceHandler handlerDispatcher;
    private static final Map customHandlers;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        handlerDispatcher = new HandlerDispatcher();
        customHandlers = new HashMap();
        try {
            IResourceManager manager = ResourceManagerImpl.getInstance();
            if (manager == null) return;
            Enumeration resources = manager.getResources(SERVICEHANDLER_XML);
            block7: while (true) {
                Object var8_9;
                Document document;
                if (resources == null) return;
                if (!resources.hasMoreElements()) {
                    return;
                }
                URL url = (URL)resources.nextElement();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                URLConnection con = url.openConnection();
                con.setUseCaches(false);
                InputStream is = con.getInputStream();
                try {
                    document = builder.parse(is);
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    is.close();
                    throw throwable;
                }
                {
                    var8_9 = null;
                }
                is.close();
                NodeList handlers = document.getElementsByTagName("handler");
                int count = handlers.getLength();
                int i = 0;
                while (true) {
                    if (i >= count) continue block7;
                    Node handler = handlers.item(i);
                    NamedNodeMap attributes = handler.getAttributes();
                    String name = attributes.getNamedItem("class").getNodeValue();
                    String param = "requestparameter";
                    String id = attributes.getNamedItem(param).getNodeValue();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rwt.internal.service.ServiceManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class<?> clazz2 = clazz.getClassLoader().loadClass(name);
                    Object handlerInstance = clazz2.newInstance();
                    ServiceManager.registerServiceHandler(id, (IServiceHandler)handlerInstance);
                    ++i;
                }
                break;
            }
        }
        catch (Throwable thr) {
            System.err.println("Could not load custom service handlers.");
            thr.printStackTrace();
        }
    }

    public static void registerServiceHandler(String id, IServiceHandler handler) {
        customHandlers.put(id, handler);
    }

    public static void unregisterServiceHandler(String id) {
        customHandlers.remove(id);
    }

    public static void setHandler(IServiceHandler serviceHandler) {
        handlerDispatcher = serviceHandler;
    }

    public static IServiceHandler getHandler() {
        return handlerDispatcher;
    }

    public static boolean isCustomHandler() {
        return customHandlers.containsKey(ServiceManager.getCustomHandlerId());
    }

    public static IServiceHandler getCustomHandler() {
        return (IServiceHandler)customHandlers.get(ServiceManager.getCustomHandlerId());
    }

    private static String getCustomHandlerId() {
        HttpServletRequest request = ContextProvider.getRequest();
        return request.getParameter("custom_service_handler");
    }

    private static IServiceHandler getLifeCycleRequestHandler() {
        if (lifeCycleRequestHandler == null) {
            lifeCycleRequestHandler = new LifeCycleServiceHandler();
        }
        return lifeCycleRequestHandler;
    }

    private static final class HandlerDispatcher
    implements IServiceHandler {
        private HandlerDispatcher() {
        }

        public void service() throws ServletException, IOException {
            if (ServiceManager.isCustomHandler()) {
                IServiceHandler customHandler = ServiceManager.getCustomHandler();
                customHandler.service();
            } else {
                ServiceManager.getLifeCycleRequestHandler().service();
            }
        }
    }
}

