/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;

public final class SessionStoreImpl
implements ISessionStore,
HttpSessionBindingListener {
    public static final String ID_SESSION_STORE;
    private final Map attributes = new HashMap();
    private final Set listeners = new HashSet();
    private final HttpSession session;
    private boolean bound;
    private boolean aboutUnbound;
    private ISessionShutdownAdapter shutdownAdapter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.SessionStoreImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_SESSION_STORE = clazz.getName();
    }

    public SessionStoreImpl(HttpSession session) {
        ParamCheck.notNull(session, "session");
        this.session = session;
        this.session.setAttribute(ID_SESSION_STORE, (Object)this);
        this.bound = true;
    }

    public void setShutdownAdapter(ISessionShutdownAdapter adapter) {
        this.shutdownAdapter = adapter;
        if (this.shutdownAdapter != null) {
            this.shutdownAdapter.setSessionStore(this);
            this.shutdownAdapter.setShutdownCallback(new Runnable(){

                public void run() {
                    SessionStoreImpl.this.doValueUnbound();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        this.checkBound();
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        this.checkBound();
        if (value == null) {
            this.removeAttribute(name);
        } else {
            Object removed = null;
            Map map = this.attributes;
            synchronized (map) {
                if (this.attributes.containsKey(name)) {
                    removed = this.removeAttributeInternal(name);
                }
                this.attributes.put(name, value);
            }
            if (removed != null) {
                this.fireValueUnbound(name, removed);
            }
            this.fireValueBound(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.checkBound();
        this.fireValueUnbound(name, this.removeAttributeInternal(name));
    }

    public Enumeration getAttributeNames() {
        this.checkBound();
        final Iterator iterator = this.attributes.keySet().iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public String getId() {
        return this.session.getId();
    }

    public HttpSession getHttpSession() {
        return this.session;
    }

    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionStoreListener(SessionStoreListener lsnr) {
        this.checkAboutUnbound();
        this.checkBound();
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionStoreListener(SessionStoreListener lsnr) {
        this.checkAboutUnbound();
        this.checkBound();
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(lsnr);
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
        this.bound = true;
        this.aboutUnbound = false;
    }

    /*
     * Exception decompiling
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 64->68)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doValueUnbound() {
        block27: {
            this.aboutUnbound = true;
            var2_1 = this.listeners;
            synchronized (var2_1) {
                lsnrs = this.listeners.toArray();
            }
            evt = new SessionStoreEvent(this);
            i = 0;
            while (i < lsnrs.length) {
                try {
                    ((SessionStoreListener)lsnrs[i]).beforeDestroy(evt);
                }
                catch (RuntimeException re) {
                    txt = "Could not execute {0}.beforeDestroy(SessionStoreEvent).";
                    param = new Object[]{lsnrs[i].getClass().getName()};
                    msg = MessageFormat.format(txt, param);
                    this.logProblem(msg, re);
                }
                ++i;
            }
            re = this.attributes;
            synchronized (re) {
                names = this.attributes.keySet().toArray();
            }
            removedAttributes = new HashSet<String>();
            try {
                i = 0;
                while (i < names.length) {
                    name = (String)names[i];
                    attribute = null;
                    var8_11 = this.attributes;
                    synchronized (var8_11) {
                        attribute = this.attributes.get(name);
                    }
                    removedAttributes.add(name);
                    try {
                        this.fireValueUnbound(name, attribute);
                    }
                    catch (RuntimeException re) {
                        txt = "Could not execute {0}.valueUnbound(HttpSessionBindingEvent).";
                        param = new Object[]{attribute.getClass().getName()};
                        msg = MessageFormat.format(txt, param);
                        this.logProblem(msg, re);
                    }
                    ++i;
                }
                var12_18 = null;
                var14_20 = this.attributes;
            }
            catch (Throwable var13_16) {
                var12_17 = null;
                var14_19 = this.attributes;
                synchronized (var14_19) {
                    iterator = removedAttributes.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw var13_16;
                        }
                        this.attributes.remove(iterator.next());
                    }
                }
            }
            synchronized (var14_20) {
                ** try [egrp 6[TRYBLOCK] [10 : 292->337)] { 
lbl74:
                // 1 sources

                iterator = removedAttributes.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        break block27;
                    }
                    this.attributes.remove(iterator.next());
                }
lbl81:
                // 1 sources

                catch (Throwable v4) {
                    throw v4;
                }
            }
        }
        this.listeners.clear();
        this.bound = false;
        this.aboutUnbound = false;
    }

    private void logProblem(String msg, Throwable thr) {
        try {
            this.session.getServletContext().log(msg, thr);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(msg);
            thr.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeAttributeInternal(String name) {
        Object result;
        Map map = this.attributes;
        synchronized (map) {
            result = this.attributes.remove(name);
        }
        return result;
    }

    private void checkBound() {
        if (!this.bound) {
            throw new IllegalStateException("The session store has been unbound.");
        }
    }

    private void checkAboutUnbound() {
        if (this.aboutUnbound) {
            String msg = "The session store is about to be unbound.";
            throw new IllegalStateException(msg);
        }
    }

    private void fireValueBound(String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            HttpSessionBindingEvent evt = new HttpSessionBindingEvent(this.session, name, value);
            listener.valueBound(evt);
        }
    }

    private void fireValueUnbound(String name, Object removed) {
        if (removed instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)removed;
            HttpSessionBindingEvent evt = new HttpSessionBindingEvent(this.session, name, removed);
            listener.valueUnbound(evt);
        }
    }
}

