/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ResourceLoader;

public final class QxImage
implements QxType {
    private static final String NONE_INPUT = "none";
    public static final QxImage NONE = new QxImage(true, null, null);
    public final boolean none;
    public final String path;
    public final ResourceLoader loader;

    private QxImage(boolean none, String path, ResourceLoader loader) {
        this.none = none;
        this.path = path;
        this.loader = loader;
    }

    public static QxImage valueOf(String input, ResourceLoader loader) {
        QxImage result;
        if (NONE_INPUT.equals(input)) {
            result = NONE;
        } else {
            if (input == null || loader == null) {
                throw new NullPointerException("null argument");
            }
            if (input.length() == 0) {
                throw new IllegalArgumentException("Empty image path");
            }
            result = new QxImage(false, input, loader);
        }
        return result;
    }

    public String toDefaultString() {
        return this.none ? NONE_INPUT : "";
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxImage) {
            QxImage other = (QxImage)object;
            result = this.path != null && this.path.equals(other.path) && this.loader != null && this.loader.equals(other.loader);
        }
        return result;
    }

    public int hashCode() {
        return this.none ? -1 : this.path.hashCode();
    }

    public String toString() {
        return "QxImage{ " + (this.none ? NONE_INPUT : this.path) + " }";
    }
}

