/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rwt.internal.theme.css.Element;

public class StylableElement
implements Element {
    private Map attributes = new HashMap();
    private List classes = new ArrayList();
    private List pseudoClasses = new ArrayList();
    private String name;
    private Element parent;

    public StylableElement(String name) {
        this(null, name);
    }

    public StylableElement(Element parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    public boolean hasName(String value) {
        return this.name == null || this.name.equals(value);
    }

    public Element getParent() {
        return this.parent;
    }

    public boolean hasClass(String value) {
        return value != null && this.classes.contains(value);
    }

    public boolean hasPseudoClass(String value) {
        return value != null && this.pseudoClasses.contains(value);
    }

    public boolean hasAttribute(String name) {
        String value = (String)this.attributes.get(name);
        return value != null && value.length() > 0;
    }

    public boolean hasAttributeValue(String name, String value) {
        String actualValue = (String)this.attributes.get(name);
        return actualValue != null && actualValue.equals(value);
    }

    public void setClass(String className) {
        if (className != null) {
            this.classes.add(className);
        }
    }

    public void resetClass(String className) {
        if (className != null && this.classes.contains(className)) {
            this.classes.remove(className);
        }
    }

    public void setPseudoClass(String pseudoName) {
        if (pseudoName != null) {
            this.pseudoClasses.add(pseudoName);
        }
    }

    public void resetPseudoClass(String pseudoName) {
        if (pseudoName != null && this.pseudoClasses.contains(pseudoName)) {
            this.pseudoClasses.remove(pseudoName);
        }
    }

    public void setAttribute(String name, String value) {
        if (name != null) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
    }

    public void setAttribute(String name) {
        this.setAttribute(name, "true");
    }

    public void resetAttribute(String name) {
        this.setAttribute(name, null);
    }
}

