/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.IColor;

public class Color
extends Resource {
    private int colorNr;

    private Color(int colorNr) {
        this.colorNr = colorNr;
    }

    public int getBlue() {
        return (this.colorNr & 0xFF0000) >> 16;
    }

    public int getGreen() {
        return (this.colorNr & 0xFF00) >> 8;
    }

    public int getRed() {
        return this.colorNr & 0xFF;
    }

    public RGB getRGB() {
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return this.colorNr;
    }

    public String toString() {
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    /* synthetic */ Color(int n, Color color) {
        this(n);
    }

    private static class ColorExt
    extends Color
    implements IColor {
        private final String colorValue;

        private ColorExt(int colorNr) {
            super(colorNr, null);
            StringBuffer buffer = new StringBuffer();
            buffer.append("#");
            this.append(buffer, Integer.toHexString(this.getRed()));
            this.append(buffer, Integer.toHexString(this.getGreen()));
            this.append(buffer, Integer.toHexString(this.getBlue()));
            this.colorValue = buffer.toString();
        }

        private void append(StringBuffer buffer, String value) {
            if (value.length() == 1) {
                buffer.append("0");
            }
            buffer.append(value);
        }

        public String toColorValue() {
            return this.colorValue;
        }
    }
}

