/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class SlimList
implements List {
    private static final Object[] EMPTY = new Object[0];
    private Object[] data = EMPTY;

    public boolean add(Object element) {
        Object[] newData = new Object[this.data.length + 1];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        newData[this.data.length] = element;
        this.data = newData;
        return true;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.size()) {
            String msg = "Index: " + index + ", Size: " + this.size();
            throw new IndexOutOfBoundsException(msg);
        }
        Object[] newData = new Object[this.data.length + 1];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        int length = newData.length - 1 - index;
        System.arraycopy(newData, index, newData, index + 1, length);
        newData[index] = element;
        this.data = newData;
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.data = EMPTY;
    }

    public boolean contains(Object object) {
        boolean result = false;
        int i = 0;
        while (!result && i < this.data.length) {
            result = this.data[i] == object;
            ++i;
        }
        return result;
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object get(int index) {
        return this.data[index];
    }

    public int indexOf(Object object) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < this.data.length) {
            if (object == this.data[i]) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index != -1) {
            Object[] newData = new Object[this.data.length - 1];
            System.arraycopy(this.data, 0, newData, 0, index);
            if (index < this.data.length - 1) {
                int length = this.data.length - index - 1;
                System.arraycopy(this.data, index + 1, newData, index, length);
            }
            this.data = newData;
        }
        return index != -1;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.data.length;
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray(Object[] a) {
        System.arraycopy(this.data, 0, a, 0, this.data.length);
        return a;
    }
}

