/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabItem;

public class TabFolder
extends Composite {
    private static final TabItem[] EMPTY_TAB_ITEMS = new TabItem[0];
    private final ItemHolder itemHolder;
    private int selectionIndex;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.TabItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemHolder = new ItemHolder(clazz);
        this.selectionIndex = -1;
    }

    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = adapter == clazz ? this.itemHolder : super.getAdapter(adapter);
        return result;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        return (TabItem[])this.itemHolder.getItems();
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        return (TabItem)this.itemHolder.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        TabItem[] result = EMPTY_TAB_ITEMS;
        if (this.getSelectionIndex() != -1) {
            TabItem selected = (TabItem)this.itemHolder.getItem(this.getSelectionIndex());
            result = new TabItem[]{selected};
        }
        return result;
    }

    public void setSelection(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = this.itemHolder.size();
        if (index >= 0 && index < count) {
            this.setSelection(index, false);
        }
    }

    private void setSelection(int index, boolean notify) {
        int oldIndex = this.getSelectionIndex();
        if (oldIndex != index) {
            int newIndex;
            TabItem item;
            Control control;
            if (oldIndex != -1 && (control = (item = (TabItem)this.itemHolder.getItem(oldIndex)).getControl()) != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            if ((newIndex = (this.selectionIndex = index)) != -1) {
                this.updateSelectedItemControl();
                if (notify) {
                    TabItem item2 = (TabItem)this.itemHolder.getItem(newIndex);
                    SelectionEvent event = new SelectionEvent(this, item2, 13);
                    event.processEvent();
                }
            }
        }
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.selectionIndex >= this.itemHolder.size()) {
            this.selectionIndex = this.itemHolder.size() - 1;
        }
        return this.selectionIndex;
    }

    public void layout() {
        this.checkWidget();
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setBounds(this.getClientArea());
            ++i;
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        int border = 1;
        int hTabBar = 23;
        return new Rectangle(border, hTabBar + border, width - border * 2, height - (hTabBar + border * 2));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point itemsSize = new Point(0, 0);
        Point contentsSize = new Point(0, 0);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Point thisItemSize = this.computeItemSize(items[i]);
            itemsSize.x += thisItemSize.x;
            itemsSize.y = Math.max(itemsSize.y, thisItemSize.y);
            Control control = items[i].getControl();
            if (control != null) {
                Point thisSize = control.computeSize(-1, -1);
                contentsSize.x = Math.max(contentsSize.x, thisSize.x);
                contentsSize.y = Math.max(contentsSize.y, thisSize.y);
            }
            ++i;
        }
        int width = Math.max(itemsSize.x, contentsSize.x);
        int height = itemsSize.y + contentsSize.y;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += 2 * border, height += 2 * border);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    void releaseChildren() {
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        super.releaseChildren();
    }

    void createItem(TabItem item, int index) {
        this.itemHolder.insert(item, index);
        if (this.getItemCount() == 1) {
            this.setSelection(0, true);
        }
    }

    void notifyResize(Point oldSize) {
        super.notifyResize(oldSize);
        this.updateSelectedItemControl();
    }

    private void updateSelectedItemControl() {
        Control control;
        int index = this.getSelectionIndex();
        if (index != -1 && (control = this.getItem(index).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
    }

    private Point computeItemSize(TabItem item) {
        Image image;
        Point result = new Point(0, 0);
        String text = item.getText();
        if (text != null) {
            Point extent = TextSizeDetermination.stringExtent(this.getFont(), text);
            result.x += extent.x + 10 + 6;
            result.y = extent.y + 4 + 6;
        }
        if ((image = item.getImage()) != null) {
            Point size = new Point(16, 16);
            result.x += size.x + 4;
            result.y = Math.max(size.x, result.x);
        }
        return result;
    }

    private static int checkStyle(int style) {
        int result = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return result & 0xFFFFFCFF;
    }
}

