/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.internal.AdapterManager;
import org.eclipse.rwt.internal.AdapterManagerImpl;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;

public final class AdapterFactoryRegistry {
    private static final List factories = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void add(Class factoryClass, Class adaptableClass) {
        ParamCheck.notNull(factoryClass, "factoryClass");
        ParamCheck.notNull(adaptableClass, "adaptableClass");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.AdapterFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(factoryClass)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = factoryClass.getName();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.rwt.AdapterFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            objectArray[1] = clazz2.getName();
            Object[] params = objectArray;
            String text = "''{0}'' is not an instance of ''{1}''.";
            String msg = MessageFormat.format(text, params);
            throw new IllegalArgumentException(msg);
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.rwt.Adaptable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz3.isAssignableFrom(adaptableClass)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = adaptableClass.getName();
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("org.eclipse.rwt.Adaptable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            objectArray[1] = clazz4.getName();
            Object[] params = objectArray;
            String text = "''{0}'' is not an instance of ''{1}''.";
            String msg = MessageFormat.format(text, params);
            throw new IllegalArgumentException(msg);
        }
        FactoryEntry[] entries = AdapterFactoryRegistry.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].factoryClass == factoryClass && entries[i].adaptableClass == adaptableClass) {
                Object[] params = new Object[]{factoryClass.getName(), adaptableClass.getName()};
                String text = "The factory ''{0}'' was already added for the adaptable ''{1}''.";
                String msg = MessageFormat.format(text, params);
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
        FactoryEntry factoryEntry = new FactoryEntry();
        factoryEntry.factoryClass = factoryClass;
        factoryEntry.adaptableClass = adaptableClass;
        factories.add(factoryEntry);
    }

    public static void register() {
        FactoryEntry[] entries = AdapterFactoryRegistry.getEntries();
        int i = 0;
        while (i < entries.length) {
            Class clazz = entries[i].factoryClass;
            try {
                AdapterFactory factory = (AdapterFactory)clazz.newInstance();
                AdapterManager manager = AdapterManagerImpl.getInstance();
                manager.registerAdapters(factory, entries[i].adaptableClass);
            }
            catch (Throwable thr) {
                String text = "Could not create an instance of ''{0}''.";
                String msg = MessageFormat.format(text, clazz);
                HttpServletRequest request = ContextProvider.getRequest();
                request.getSession().getServletContext().log(msg, thr);
            }
            ++i;
        }
    }

    public static void clear() {
        factories.clear();
    }

    private static FactoryEntry[] getEntries() {
        FactoryEntry[] entries = new FactoryEntry[factories.size()];
        factories.toArray(entries);
        return entries;
    }

    private static final class FactoryEntry {
        private Class factoryClass;
        private Class adaptableClass;

        private FactoryEntry() {
        }
    }
}

