/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import org.eclipse.rwt.internal.theme.css.ConditionExt;
import org.eclipse.rwt.internal.theme.css.Element;
import org.eclipse.rwt.internal.theme.css.ElementMatcher;
import org.eclipse.rwt.internal.theme.css.Specific;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;

public class AndConditionImpl
implements CombinatorCondition,
ConditionExt {
    private final Condition first;
    private final Condition second;

    public AndConditionImpl(Condition first, Condition second) {
        this.first = first;
        this.second = second;
    }

    public Condition getFirstCondition() {
        return this.first;
    }

    public Condition getSecondCondition() {
        return this.second;
    }

    public short getConditionType() {
        return 0;
    }

    public boolean matches(Element element) {
        ElementMatcher firstMatcher = (ElementMatcher)((Object)this.first);
        ElementMatcher secondMatcher = (ElementMatcher)((Object)this.second);
        return firstMatcher.matches(element) && secondMatcher.matches(element);
    }

    public int getSpecificity() {
        Specific specificFirst = (Specific)((Object)this.first);
        Specific specificSecond = (Specific)((Object)this.second);
        return specificFirst.getSpecificity() + specificSecond.getSpecificity();
    }

    public String[] getClasses() {
        String[] classes1 = ((ConditionExt)((Object)this.first)).getClasses();
        String[] classes2 = ((ConditionExt)((Object)this.second)).getClasses();
        String[] result = null;
        if (classes1 == null) {
            result = classes2;
        } else if (classes2 == null) {
            result = classes1;
        } else {
            result = new String[classes1.length + classes2.length];
            System.arraycopy(classes1, 0, result, 0, classes1.length);
            System.arraycopy(classes2, 0, result, classes1.length, classes2.length);
        }
        return result;
    }

    public String[] getConstraints() {
        String[] cond1 = ((ConditionExt)((Object)this.first)).getConstraints();
        String[] cond2 = ((ConditionExt)((Object)this.second)).getConstraints();
        String[] result = new String[cond1.length + cond2.length];
        System.arraycopy(cond1, 0, result, 0, cond1.length);
        System.arraycopy(cond2, 0, result, cond1.length, cond2.length);
        return result;
    }

    public String toString() {
        return String.valueOf(this.first.toString()) + this.second.toString();
    }
}

