/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    private static final int SIZE_BASE = 16;
    private int minimum;
    private int selection;
    private int maximum = 100;

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        int currStyle = style | 0x80000;
        return ProgressBar.checkBits(currStyle, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 160;
            height += 16;
        } else {
            width += 16;
            height += 160;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value > this.getMinimum()) {
            this.maximum = value;
            if (this.selection > this.maximum) {
                this.selection = this.maximum;
            }
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value > 0 && value < this.getMaximum()) {
            this.minimum = value;
            if (this.minimum > this.selection) {
                this.selection = this.minimum;
            }
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.selection = value < this.minimum ? this.minimum : (value > this.maximum ? this.maximum : value);
    }
}

