/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.graphics.ResourceFactory;

public final class FontData {
    private final String name;
    private final int height;
    private final int style;

    public FontData(String name, int height, int style) {
        if (name == null) {
            SWT.error(4);
        }
        this.name = name;
        this.height = height;
        this.style = style;
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string.indexOf(124);
        if (end == -1) {
            SWT.error(5);
        }
        String version1 = string.substring(start, end);
        try {
            if (Integer.parseInt(version1) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((end = string.indexOf(124, start = end + 1)) == -1) {
            SWT.error(5);
        }
        String name = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        int height = 0;
        try {
            height = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        this.name = name;
        this.height = height;
        this.style = style;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeight());
        buffer.append("|");
        buffer.append(this.getStyle());
        buffer.append("|");
        return buffer.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof FontData) {
            FontData toCompare = (FontData)obj;
            result = this.name.hashCode() == toCompare.name.hashCode() && this.height == toCompare.height && this.style == toCompare.style;
        }
        return result;
    }

    public int hashCode() {
        return ResourceFactory.fontHashCode(this.name, this.height, this.style);
    }
}

