/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.branding;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.branding.Header;
import org.eclipse.rwt.internal.branding.BrandingManager;
import org.eclipse.rwt.internal.lifecycle.CommonPatterns;
import org.eclipse.rwt.internal.service.BrowserSurvey;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.TemplateHolder;

public final class BrandingUtil {
    private static final String ATTR_BRANDING_ID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.branding.BrandingUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATTR_BRANDING_ID = String.valueOf(clazz.getName()) + "#brandingId";
    }

    public static void replacePlaceholder(TemplateHolder template, TemplateHolder.Variable variable, String replacement) {
        String safeReplacement = replacement == null ? "" : replacement;
        template.replace(variable, safeReplacement);
    }

    public static String headerMarkup(AbstractBranding branding) {
        Header[] headers = branding.getHeaders();
        StringBuffer buffer = new StringBuffer();
        BrandingUtil.appendFavIconMarkup(buffer, branding);
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                Header header = headers[i];
                BrandingUtil.appendHeaderMarkup(buffer, header);
                buffer.append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    public static String exitMessageScript(AbstractBranding branding) {
        String exitMessage;
        String result = "";
        if (branding.showExitConfirmation() && (exitMessage = branding.getExitConfirmationText()) != null && exitMessage != "") {
            exitMessage = BrandingUtil.escapeString(exitMessage);
            result = "app.setExitConfirmation( \"" + exitMessage + "\" );";
        }
        return result;
    }

    public static AbstractBranding findBranding() {
        HttpServletRequest request = ContextProvider.getRequest();
        String servletName = BrowserSurvey.getSerlvetName();
        String entryPoint = request.getParameter("startup");
        AbstractBranding branding = BrandingManager.get(servletName, entryPoint);
        RWT.getSessionStore().setAttribute(ATTR_BRANDING_ID, branding.getId());
        return branding;
    }

    public static String getCurrentBrandingId() {
        return (String)RWT.getSessionStore().getAttribute(ATTR_BRANDING_ID);
    }

    private static void appendFavIconMarkup(StringBuffer buffer, AbstractBranding branding) {
        String favIcon = branding.getFavIcon();
        if (favIcon != null && !"".equals(favIcon)) {
            String[] names = new String[]{"rel", "type", "href"};
            String[] values = new String[]{"shortcut icon", "image/x-icon", favIcon};
            Header header = new Header("link", names, values);
            BrandingUtil.appendHeaderMarkup(buffer, header);
            buffer.append("\n");
        }
    }

    private static String appendHeaderMarkup(StringBuffer buffer, Header header) {
        buffer.append("<");
        buffer.append(header.getTagName());
        buffer.append(" ");
        String[] names = header.getNames();
        String[] values = header.getValues();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = values[i];
            if (name != null && value != null) {
                buffer.append(name);
                buffer.append("=\"");
                buffer.append(value);
                buffer.append("\" ");
            }
            ++i;
        }
        buffer.append("/>");
        return buffer.toString();
    }

    private static String escapeString(String input) {
        String result = CommonPatterns.escapeDoubleQuoted(input);
        return CommonPatterns.replaceNewLines(result);
    }

    private BrandingUtil() {
    }
}

