/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public final class UICallBackManager
implements SessionStoreListener {
    private static Timer sendTimer;
    List runnables = new ArrayList();
    private final Object runnablesLock = new Object();
    private final Set locked = new HashSet();
    private boolean uiThreadRunning = false;
    private boolean waitForUIThread = false;
    private boolean active = false;
    static /* synthetic */ Class class$0;

    public static UICallBackManager getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object inst = SessionSingletonBase.getInstance(clazz);
        return (UICallBackManager)inst;
    }

    private UICallBackManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCallBackRequestBlocked() {
        Object object = this.runnablesLock;
        synchronized (object) {
            return !this.locked.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        Object object = this.runnablesLock;
        synchronized (object) {
            this.active = active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUICallBack(long time) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (sendTimer == null) {
                sendTimer = new Timer(true);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            TimerTask task = new TimerTask(){

                public void run() {
                    UICallBackManager.this.sendUICallBack();
                }
            };
            sendTimer.schedule(task, new Date(time));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUICallBack() {
        Object object = this.runnablesLock;
        synchronized (object) {
            if (!this.uiThreadRunning || !this.active) {
                this.sendImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendImmediately() {
        Object object = this.runnablesLock;
        synchronized (object) {
            this.runnablesLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsync(Display display, Runnable runnable) {
        Object object = this.runnablesLock;
        synchronized (object) {
            this.runnables.add(new RunnableBase(runnable));
            if (Thread.currentThread() != display.getThread()) {
                this.sendUICallBack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSync(Display display, Runnable runnable) {
        if (Thread.currentThread() == display.getThread()) {
            runnable.run();
        } else {
            SyncRunnable syncRunnable = new SyncRunnable(runnable);
            Object object = this.runnablesLock;
            synchronized (object) {
                this.runnables.add(syncRunnable);
            }
            this.sendUICallBack();
            syncRunnable.block();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimer(Display display, Runnable runnable, long time) {
        if (time < 0L) {
            this.removeTimer(runnable);
        } else {
            Object object = this.runnablesLock;
            synchronized (object) {
                TimerRunnable timerRunnable = new TimerRunnable(runnable, time);
                this.runnables.add(timerRunnable);
                if (Thread.currentThread() != display.getThread()) {
                    this.sendUICallBack(time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimer(Runnable runnable) {
        Object object = this.runnablesLock;
        synchronized (object) {
            Iterator iter = this.runnables.iterator();
            boolean found = false;
            while (!found && iter.hasNext()) {
                RunnableBase next = (RunnableBase)iter.next();
                if (!next.equalsRunnable(runnable)) continue;
                this.runnables.remove(next);
                found = true;
            }
        }
    }

    void notifyUIThreadStart() {
        this.uiThreadRunning = true;
        this.waitForUIThread = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyUIThreadEnd() {
        this.uiThreadRunning = false;
        Object object = this.runnablesLock;
        synchronized (object) {
            if (!this.runnables.isEmpty()) {
                this.sendUICallBack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNextRunnableInUIThread() {
        RunnableBase runnable = null;
        Object object = this.runnablesLock;
        synchronized (object) {
            Iterator iter = this.runnables.iterator();
            while (runnable == null && iter.hasNext()) {
                RunnableBase next = (RunnableBase)iter.next();
                if (!next.canRun()) continue;
                runnable = next;
                this.runnables.remove(runnable);
            }
        }
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                SWT.error(46, t);
            }
        }
        return runnable != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean blockCallBackRequest() {
        boolean result = false;
        Object object = this.runnablesLock;
        synchronized (object) {
            final Thread currentThread = Thread.currentThread();
            SessionStoreListener listener = new SessionStoreListener(){

                public void beforeDestroy(SessionStoreEvent event) {
                    currentThread.interrupt();
                }
            };
            try {
                try {
                    if (this.mustBlockCallBackRequest()) {
                        this.locked.add(currentThread);
                        ISessionStore session = ContextProvider.getSession();
                        session.addSessionStoreListener(listener);
                        this.runnablesLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    result = true;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.locked.remove(currentThread);
                if (result) throw throwable;
                try {
                    ContextProvider.getSession().removeSessionStoreListener(listener);
                    throw throwable;
                }
                catch (IllegalStateException illegalStateException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                this.locked.remove(currentThread);
            }
            if (!result) {
                try {}
                catch (IllegalStateException illegalStateException) {}
                ContextProvider.getSession().removeSessionStoreListener(listener);
            }
            this.waitForUIThread = true;
            return result;
        }
    }

    private boolean mustBlockCallBackRequest() {
        return this.active && this.locked.isEmpty() && (this.waitForUIThread || this.uiThreadRunning || this.runnables.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDestroy(SessionStoreEvent event) {
        Object object = this.runnablesLock;
        synchronized (object) {
            if (this.runnables != null) {
                RunnableBase[] toBeExecuted = new RunnableBase[this.runnables.size()];
                this.runnables.toArray(toBeExecuted);
                int i = 0;
                while (i < toBeExecuted.length) {
                    RunnableBase runnable = toBeExecuted[i];
                    if (runnable.canRun()) {
                        runnable.run();
                    }
                    ++i;
                }
                this.sendImmediately();
            }
            this.runnables.clear();
            this.runnables = null;
        }
    }

    static class RunnableBase {
        private final Runnable runnable;

        RunnableBase(Runnable runnable) {
            this.runnable = runnable;
        }

        boolean canRun() {
            return true;
        }

        void run() {
            if (this.runnable != null) {
                this.runnable.run();
            }
        }

        boolean equalsRunnable(Runnable runnable) {
            return this.runnable == runnable;
        }
    }

    static final class SyncRunnable
    extends RunnableBase {
        private final Object lock = new Object();
        private boolean terminated;

        SyncRunnable(Runnable runnable) {
            super(runnable);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void run() {
            try {
                super.run();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.notifyBlocked();
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.notifyBlocked();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyBlocked() {
            Object object = this.lock;
            synchronized (object) {
                this.terminated = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void block() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.terminated) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static final class TimerRunnable
    extends RunnableBase {
        private final long time;

        TimerRunnable(Runnable runnable, long time) {
            super(runnable);
            this.time = time;
        }

        boolean canRun() {
            return System.currentTimeMillis() >= this.time;
        }
    }
}

