/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.swt.graphics.Color;

public class QxColor
implements QxType {
    private static final String TRANSPARENT_STR = "transparent";
    private static final Map NAMED_COLORS = new HashMap();
    public static final QxColor BLACK = new QxColor(0, 0, 0);
    public static final QxColor WHITE = new QxColor(255, 255, 255);
    public static final QxColor TRANSPARENT = new QxColor();
    public final int red;
    public final int green;
    public final int blue;
    public final boolean transparent;

    static {
        NAMED_COLORS.put("black", new int[3]);
        NAMED_COLORS.put("gray", new int[]{128, 128, 128});
        NAMED_COLORS.put("silver", new int[]{192, 192, 192});
        NAMED_COLORS.put("white", new int[]{255, 255, 255});
        int[] nArray = new int[3];
        nArray[0] = 128;
        NAMED_COLORS.put("maroon", nArray);
        int[] nArray2 = new int[3];
        nArray2[0] = 255;
        NAMED_COLORS.put("red", nArray2);
        int[] nArray3 = new int[3];
        nArray3[0] = 128;
        nArray3[2] = 128;
        NAMED_COLORS.put("purple", nArray3);
        int[] nArray4 = new int[3];
        nArray4[0] = 255;
        nArray4[2] = 255;
        NAMED_COLORS.put("fuchsia", nArray4);
        int[] nArray5 = new int[3];
        nArray5[1] = 128;
        NAMED_COLORS.put("green", nArray5);
        int[] nArray6 = new int[3];
        nArray6[1] = 255;
        NAMED_COLORS.put("lime", nArray6);
        int[] nArray7 = new int[3];
        nArray7[2] = 128;
        NAMED_COLORS.put("navy", nArray7);
        int[] nArray8 = new int[3];
        nArray8[2] = 255;
        NAMED_COLORS.put("blue", nArray8);
        int[] nArray9 = new int[3];
        nArray9[0] = 128;
        nArray9[1] = 128;
        NAMED_COLORS.put("olive", nArray9);
        int[] nArray10 = new int[3];
        nArray10[0] = 255;
        nArray10[1] = 255;
        NAMED_COLORS.put("yellow", nArray10);
        int[] nArray11 = new int[3];
        nArray11[1] = 128;
        nArray11[2] = 128;
        NAMED_COLORS.put("teal", nArray11);
        int[] nArray12 = new int[3];
        nArray12[1] = 255;
        nArray12[2] = 255;
        NAMED_COLORS.put("aqua", nArray12);
    }

    private QxColor() {
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.transparent = true;
    }

    private QxColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.transparent = false;
    }

    public static QxColor create(int red, int green, int blue) {
        QxColor result = red == 0 && green == 0 && blue == 0 ? BLACK : (red == 255 && green == 255 && blue == 255 ? WHITE : new QxColor(red, green, blue));
        return result;
    }

    public static QxColor valueOf(String input) {
        QxColor result;
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        if (TRANSPARENT_STR.equals(input)) {
            result = TRANSPARENT;
        } else {
            int blue;
            int green;
            int red;
            if (input.startsWith("#")) {
                try {
                    if (input.length() == 7) {
                        red = Integer.parseInt(input.substring(1, 3), 16);
                        green = Integer.parseInt(input.substring(3, 5), 16);
                        blue = Integer.parseInt(input.substring(5, 7), 16);
                    }
                    if (input.length() == 4) {
                        red = Integer.parseInt(input.substring(1, 2), 16) * 17;
                        green = Integer.parseInt(input.substring(2, 3), 16) * 17;
                        blue = Integer.parseInt(input.substring(3, 4), 16) * 17;
                    }
                    String pattern = "Illegal number of characters in color definition ''{0}''";
                    Object[] arguments = new Object[]{input};
                    String message = MessageFormat.format(pattern, arguments);
                    throw new IllegalArgumentException(message);
                }
                catch (NumberFormatException numberFormatException) {
                    String pattern = "Illegal number format in color definition ''{0}''";
                    Object[] arguments = new Object[]{input};
                    String message = MessageFormat.format(pattern, arguments);
                    throw new IllegalArgumentException(message);
                }
            } else if (NAMED_COLORS.containsKey(input.toLowerCase())) {
                int[] values = (int[])NAMED_COLORS.get(input.toLowerCase());
                red = values[0];
                green = values[1];
                blue = values[2];
            } else {
                String[] parts = input.split("\\s*,\\s*");
                if (parts.length == 3) {
                    try {
                        red = Integer.parseInt(parts[0]);
                        green = Integer.parseInt(parts[1]);
                        blue = Integer.parseInt(parts[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String pattern = "Illegal number format in color definition ''{0}''";
                        Object[] arguments = new Object[]{input};
                        String message = MessageFormat.format(pattern, arguments);
                        throw new IllegalArgumentException(message);
                    }
                } else {
                    String pattern = "Invalid color name ''{0}''";
                    Object[] arguments = new Object[]{input};
                    String message = MessageFormat.format(pattern, arguments);
                    throw new IllegalArgumentException(message);
                }
            }
            result = QxColor.create(red, green, blue);
        }
        return result;
    }

    public String toDefaultString() {
        return this.transparent ? TRANSPARENT_STR : QxColor.toHtmlString(this.red, this.green, this.blue);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj instanceof QxColor) {
            QxColor other = (QxColor)obj;
            result = other.red == this.red && other.green == this.green && other.blue == this.blue;
        }
        return result;
    }

    public int hashCode() {
        return this.transparent ? -1 : this.red + this.green * 256 + this.blue * 65536;
    }

    public String toString() {
        String colors = String.valueOf(this.red) + ", " + this.green + ", " + this.blue;
        return "QxColor{ " + (this.transparent ? TRANSPARENT_STR : colors) + " }";
    }

    public static String toHtmlString(int red, int green, int blue) {
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(QxColor.getHexStr(red));
        sb.append(QxColor.getHexStr(green));
        sb.append(QxColor.getHexStr(blue));
        return sb.toString();
    }

    public static Color createColor(QxColor color) {
        Color result = null;
        if (!color.transparent) {
            result = Graphics.getColor(color.red, color.green, color.blue);
        }
        return result;
    }

    private static String getHexStr(int value) {
        String hex = Integer.toHexString(value);
        return hex.length() == 1 ? "0" + hex : hex;
    }
}

