/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.internal.theme.css.IStylePropertyMap;
import org.eclipse.rwt.internal.theme.css.SelectorExt;
import org.eclipse.rwt.internal.theme.css.StylableElement;
import org.eclipse.rwt.internal.theme.css.StyleRule;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public final class StyleSheet {
    private static final SelectorWrapperComparator COMPARATOR = new SelectorWrapperComparator();
    private final StyleRule[] styleRules;
    private SelectorWrapper[] selectorWrappers;

    public StyleSheet(StyleRule[] styleRules) {
        this.styleRules = styleRules;
        this.createSelectorWrappers();
    }

    public StyleRule[] getStyleRules() {
        return this.styleRules;
    }

    public SelectorWrapper[] getMatchingStyleRules(String elementName) {
        ArrayList<SelectorWrapper> buffer = new ArrayList<SelectorWrapper>();
        int i = 0;
        while (i < this.selectorWrappers.length) {
            SelectorWrapper selectorWrapper = this.selectorWrappers[i];
            String selectorElement = selectorWrapper.selectorExt.getElementName();
            if (selectorElement == null || selectorElement.equals(elementName)) {
                buffer.add(selectorWrapper);
            }
            ++i;
        }
        SelectorWrapper[] result = new SelectorWrapper[buffer.size()];
        buffer.toArray(result);
        return result;
    }

    public ConditionalValue[] getValues(String elementName, String propertyName) {
        ArrayList<ConditionalValue> buffer = new ArrayList<ConditionalValue>();
        int i = 0;
        while (i < this.selectorWrappers.length) {
            QxType value;
            SelectorWrapper selectorWrapper = this.selectorWrappers[i];
            String selectorElement = selectorWrapper.selectorExt.getElementName();
            if ((selectorElement == null || selectorElement.equals(elementName)) && (value = selectorWrapper.propertyMap.getValue(propertyName)) != null) {
                String[] constraints = selectorWrapper.selectorExt.getConstraints();
                ConditionalValue condValue = new ConditionalValue(constraints, value);
                buffer.add(condValue);
            }
            ++i;
        }
        ConditionalValue[] result = new ConditionalValue[buffer.size()];
        buffer.toArray(result);
        return result;
    }

    public QxType getValue(String cssProperty, StylableElement element) {
        QxType result = null;
        SelectorWrapper[] selectorWrappers = this.getMatchingSelectors(element);
        int i = 0;
        while (i < selectorWrappers.length && result == null) {
            IStylePropertyMap properties = selectorWrappers[i].propertyMap;
            QxType value = properties.getValue(cssProperty);
            if (value != null) {
                result = value;
            }
            ++i;
        }
        return result;
    }

    public String[] getVariants(String elementName) {
        ArrayList<String> classesList = new ArrayList<String>();
        int i = 0;
        while (i < this.selectorWrappers.length) {
            String[] classes;
            SelectorExt selectorExt = this.selectorWrappers[i].selectorExt;
            if ((selectorExt.getElementName() == null || selectorExt.getElementName().equals(elementName)) && (classes = selectorExt.getClasses()) != null) {
                int j = 0;
                while (j < classes.length) {
                    String className = classes[j];
                    if (!classesList.contains(className)) {
                        classesList.add(className);
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] result = new String[classesList.size()];
        classesList.toArray(result);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        StyleRule[] styleRules = this.getStyleRules();
        int i = 0;
        while (i < styleRules.length) {
            StyleRule styleRule = styleRules[i];
            SelectorList selectors = styleRule.getSelectors();
            int length = selectors.getLength();
            int j = 0;
            while (j < length) {
                Selector selector = selectors.item(j);
                buffer.append(selector);
                buffer.append("\n");
                ++j;
            }
            IStylePropertyMap properties = styleRule.getProperties();
            buffer.append(properties);
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    private void createSelectorWrappers() {
        ArrayList<SelectorWrapper> selectorWrappersList = new ArrayList<SelectorWrapper>();
        int i_rule = 0;
        while (i_rule < this.styleRules.length) {
            StyleRule styleRule = this.styleRules[i_rule];
            SelectorList selectors = styleRule.getSelectors();
            IStylePropertyMap properties = styleRule.getProperties();
            int length = selectors.getLength();
            int i_sel = 0;
            while (i_sel < length) {
                Selector selector = selectors.item(i_sel);
                SelectorWrapper selectorWrapper = new SelectorWrapper(selector, properties, i_rule);
                selectorWrappersList.add(selectorWrapper);
                ++i_sel;
            }
            ++i_rule;
        }
        Collections.sort(selectorWrappersList, COMPARATOR);
        Collections.reverse(selectorWrappersList);
        this.selectorWrappers = new SelectorWrapper[selectorWrappersList.size()];
        selectorWrappersList.toArray(this.selectorWrappers);
    }

    private SelectorWrapper[] getMatchingSelectors(StylableElement element) {
        ArrayList<SelectorWrapper> resultList = new ArrayList<SelectorWrapper>();
        int i = 0;
        while (i < this.selectorWrappers.length) {
            SelectorWrapper selectorWrapper = this.selectorWrappers[i];
            if (selectorWrapper.selectorExt.matches(element)) {
                resultList.add(selectorWrapper);
            }
            ++i;
        }
        SelectorWrapper[] result = new SelectorWrapper[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public static class SelectorWrapper {
        public final Selector selector;
        public final SelectorExt selectorExt;
        public final IStylePropertyMap propertyMap;
        public final int position;

        public SelectorWrapper(Selector selector, IStylePropertyMap propertyMap, int position) {
            this.selector = selector;
            this.selectorExt = (SelectorExt)((Object)selector);
            this.position = position;
            this.propertyMap = propertyMap;
        }
    }

    private static class SelectorWrapperComparator
    implements Comparator {
        private SelectorWrapperComparator() {
        }

        public int compare(Object object1, Object object2) {
            int specificity2;
            int result = 0;
            SelectorWrapper selectorWrapper1 = (SelectorWrapper)object1;
            SelectorWrapper selectorWrapper2 = (SelectorWrapper)object2;
            int specificity1 = selectorWrapper1.selectorExt.getSpecificity();
            if (specificity1 > (specificity2 = selectorWrapper2.selectorExt.getSpecificity())) {
                result = 1;
            } else if (specificity1 < specificity2) {
                result = -1;
            } else if (selectorWrapper1.position > selectorWrapper2.position) {
                result = 1;
            } else if (selectorWrapper1.position < selectorWrapper2.position) {
                result = -1;
            }
            return result;
        }
    }
}

