/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.math.BigDecimal;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.TextSizeDataBase;
import org.eclipse.swt.internal.graphics.TextSizeDeterminationFacade;
import org.eclipse.swt.internal.graphics.TextSizeDeterminationHandler;
import org.eclipse.swt.internal.graphics.TextSizeEstimation;
import org.eclipse.swt.internal.graphics.TextSizeProbeStore;

public class TextSizeDetermination {
    private static final String HAS_CALCULATOR;
    private static final String CALCULATION_ITEMS;
    private static final ICalculationItem[] EMTY_ITEMS;
    private static final int STRING_EXTENT = 0;
    private static final int TEXT_EXTENT = 1;
    private static final int MARKUP_EXTENT = 2;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.graphics.TextSizeDetermination");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HAS_CALCULATOR = String.valueOf(clazz.getName()) + ".hasCalculator";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.internal.graphics.TextSizeDetermination");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CALCULATION_ITEMS = String.valueOf(clazz2.getName()) + ".CalculationItems";
        EMTY_ITEMS = new ICalculationItem[0];
    }

    private TextSizeDetermination() {
    }

    public static Point stringExtent(Font font, String string) {
        Point result = string.length() == 0 ? new Point(0, TextSizeDetermination.getCharHeight(font)) : TextSizeDetermination.doMeasurement(font, string, -1, 0);
        return result;
    }

    public static Point textExtent(Font font, String string, int wrapWidth) {
        return TextSizeDetermination.internalExtent(font, string, wrapWidth, 1);
    }

    public static Point markupExtent(Font font, String string, int wrapWidth) {
        return TextSizeDetermination.internalExtent(font, string, wrapWidth, 2);
    }

    private static Point internalExtent(Font font, String string, int wrapWidth, int estMode) {
        Point result;
        int estimationMode = estMode;
        if (wrapWidth <= 0) {
            result = TextSizeDetermination.doMeasurement(font, string, wrapWidth, estimationMode);
        } else {
            Point testSize = TextSizeDetermination.doMeasurement(font, string, wrapWidth, estimationMode);
            if (testSize.x <= wrapWidth) {
                result = testSize;
            } else {
                result = TextSizeEstimation.textExtent(font, string, wrapWidth);
                BigDecimal height = new BigDecimal((double)result.y);
                BigDecimal charHeight = new BigDecimal((double)TextSizeEstimation.getCharHeight(font));
                int rows = height.divide(charHeight, 0, 4).intValue();
                result.y = TextSizeDetermination.getCharHeight(font) * rows;
            }
        }
        return result;
    }

    private static Point doMeasurement(Font font, String string, int wrapWidth, int estimationMode) {
        Point result;
        boolean expandNewLines = estimationMode == 1;
        String toMeasure = string;
        if (estimationMode != 2) {
            toMeasure = TextSizeDeterminationFacade.createMeasureString(string, expandNewLines);
        }
        if ((result = TextSizeDataBase.lookup(font, toMeasure, wrapWidth)) == null) {
            switch (estimationMode) {
                case 2: {
                    result = TextSizeEstimation.textExtent(font, toMeasure, wrapWidth);
                    break;
                }
                case 1: {
                    result = TextSizeEstimation.textExtent(font, string, wrapWidth);
                    break;
                }
                case 0: {
                    result = TextSizeEstimation.stringExtent(font, string);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown estimation mode.");
                }
            }
            TextSizeDetermination.addCalculationItem(font, toMeasure, wrapWidth);
        }
        if (result.y == 0) {
            result.y = TextSizeDetermination.getCharHeight(font);
        }
        return result;
    }

    public static int getCharHeight(Font font) {
        int result;
        TextSizeProbeStore probeStore = TextSizeProbeStore.getInstance();
        if (probeStore.containsProbeResult(font)) {
            TextSizeProbeStore.IProbeResult probeResult = probeStore.getProbeResult(font);
            result = probeResult.getSize().y;
        } else {
            TextSizeProbeStore.addProbeRequest(font);
            result = TextSizeEstimation.getCharHeight(font);
        }
        return result;
    }

    public static float getAvgCharWidth(Font font) {
        float result;
        TextSizeProbeStore probeStore = TextSizeProbeStore.getInstance();
        if (probeStore.containsProbeResult(font)) {
            TextSizeProbeStore.IProbeResult probeResult = probeStore.getProbeResult(font);
            result = probeResult.getAvgCharWidth();
        } else {
            TextSizeProbeStore.addProbeRequest(font);
            result = TextSizeEstimation.getAvgCharWidth(font);
        }
        return result;
    }

    public static void readStartupProbes() {
        TextSizeProbeStore.IProbe[] probeList = TextSizeProbeStore.getProbeList();
        TextSizeDeterminationHandler.readProbedFonts(probeList);
    }

    public static int getProbeCount() {
        return TextSizeProbeStore.getProbeList().length;
    }

    public static ICalculationItem[] getCalculationItems() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        ICalculationItem[] result = (ICalculationItem[])stateInfo.getAttribute(CALCULATION_ITEMS);
        if (result == null) {
            result = EMTY_ITEMS;
        }
        return result;
    }

    private static void addCalculationItem(final Font font, final String string, final int wrapWidth) {
        ICalculationItem[] oldItems = TextSizeDetermination.getCalculationItems();
        boolean mustAdd = true;
        int i = 0;
        while (mustAdd && i < oldItems.length) {
            FontData oldFontData = oldItems[i].getFont().getFontData()[0];
            mustAdd = !oldItems[i].getString().equals(string) || !oldFontData.equals(font.getFontData()[0]) || oldItems[i].getWrapWidth() != wrapWidth;
            ++i;
        }
        if (mustAdd) {
            ICalculationItem[] newItems = new ICalculationItem[oldItems.length + 1];
            System.arraycopy(oldItems, 0, newItems, 0, oldItems.length);
            newItems[oldItems.length] = new ICalculationItem(){

                public Font getFont() {
                    return font;
                }

                public String getString() {
                    return string;
                }

                public int getWrapWidth() {
                    return wrapWidth;
                }
            };
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            stateInfo.setAttribute(CALCULATION_ITEMS, newItems);
            if (stateInfo.getAttribute(HAS_CALCULATOR) == null) {
                stateInfo.setAttribute(HAS_CALCULATOR, new Object());
                TextSizeDeterminationHandler.register();
            }
        }
    }

    public static interface ICalculationItem {
        public Font getFont();

        public String getString();

        public int getWrapWidth();
    }
}

