/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class WidgetTreeVisitor {
    public static void accept(Widget root, WidgetTreeVisitor visitor) {
        if (root instanceof Composite) {
            Composite composite = (Composite)root;
            if (visitor.visit(composite)) {
                WidgetTreeVisitor.handleMenus(composite, visitor);
                WidgetTreeVisitor.handleItems(root, visitor);
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    WidgetTreeVisitor.accept(children[i], visitor);
                    ++i;
                }
            }
        } else if (ItemHolder.isItemHolder(root)) {
            if (visitor.visit(root)) {
                WidgetTreeVisitor.handleItems(root, visitor);
            }
        } else {
            visitor.visit(root);
        }
    }

    public boolean visit(Widget widget) {
        return true;
    }

    public boolean visit(Composite composite) {
        return true;
    }

    private static void handleMenus(Composite composite, WidgetTreeVisitor visitor) {
        if (MenuHolder.isMenuHolder(composite)) {
            Menu[] menus = MenuHolder.getMenus(composite);
            int i = 0;
            while (i < menus.length) {
                WidgetTreeVisitor.accept(menus[i], visitor);
                ++i;
            }
        }
    }

    private static void handleItems(Widget root, WidgetTreeVisitor visitor) {
        if (ItemHolder.isItemHolder(root)) {
            Item[] items = ItemHolder.getItems(root);
            int i = 0;
            while (i < items.length) {
                WidgetTreeVisitor.accept(items[i], visitor);
                ++i;
            }
        }
    }

    public static abstract class AllWidgetTreeVisitor
    extends WidgetTreeVisitor {
        public final boolean visit(Widget widget) {
            return this.doVisit(widget);
        }

        public final boolean visit(Composite composite) {
            return this.doVisit(composite);
        }

        public abstract boolean doVisit(Widget var1);
    }
}

