/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.ListModel;
import org.eclipse.swt.internal.widgets.combokit.ComboThemeAdapter;
import org.eclipse.swt.widgets.Composite;

public class Combo
extends Composite {
    private static final int DROP_DOWN_BUTTON_WIDTH = 14;
    private final ListModel model = new ListModel(true);
    private String text = "";
    private int visibleCount = 5;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.model.getSelectionIndex();
    }

    public void select(int selectionIndex) {
        this.checkWidget();
        this.model.setSelection(selectionIndex);
        this.updateText();
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == this.model.getSelectionIndex()) {
            this.model.setSelection(-1);
        }
        this.updateText();
    }

    public void deselectAll() {
        this.checkWidget();
        this.model.deselectAll();
        this.text = "";
        this.fireModifyEvent();
    }

    public void clearSelection() {
        this.checkWidget();
    }

    public void add(String string) {
        this.checkWidget();
        this.model.add(string);
    }

    public void add(String string, int index) {
        this.checkWidget();
        this.model.add(string, index);
    }

    public void remove(int index) {
        this.checkWidget();
        int selectionIndex = this.getSelectionIndex();
        if (selectionIndex == index) {
            this.deselect(index);
        }
        this.model.remove(index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        int selectionIndex = this.getSelectionIndex();
        String[] items = this.model.getItems();
        int i = start;
        while (i <= end) {
            int indexTemp = this.indexOf(items[i]);
            if (selectionIndex == indexTemp) {
                this.deselect(indexTemp);
            }
            ++i;
        }
        this.model.remove(start, end);
    }

    public void remove(String string) {
        this.checkWidget();
        int indexOfThisString = this.indexOf(string);
        int selectionIndex = this.getSelectionIndex();
        if (selectionIndex == indexOfThisString) {
            this.deselect(indexOfThisString);
        }
        this.model.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.deselectAll();
        this.model.removeAll();
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        this.model.setItem(index, string);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.model.setItems(items);
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.model.getItem(index);
    }

    public String[] getItems() {
        this.checkWidget();
        return this.model.getItems();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.model.getItemCount();
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count >= 0) {
            this.visibleCount = count;
        }
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (start < 0 || start >= this.model.getItemCount()) {
            return -1;
        }
        int i = start;
        while (i < this.model.getItemCount()) {
            if (string.equals(this.model.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getText() {
        this.checkWidget();
        String result = "";
        if ((this.style & 8) != 0) {
            int idx = this.model.getSelectionIndex();
            if (idx != -1) {
                result = this.model.getItem(idx);
            }
        } else {
            result = this.text;
        }
        return result;
    }

    public void setText(String string) {
        String verifiedText;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index == -1) {
                return;
            }
            this.select(index);
        }
        if ((verifiedText = this.verifyText(string, 0, this.text.length())) != null) {
            this.model.deselectAll();
            String[] items = this.model.getItems();
            int i = 0;
            while (i < items.length) {
                if (verifiedText == items[i]) {
                    this.model.setSelection(i);
                    break;
                }
                ++i;
            }
            this.text = verifiedText;
            this.fireModifyEvent();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = TextSizeDetermination.getCharHeight(this.getFont());
        if (wHint == -1 || hHint == -1) {
            String[] items = this.model.getItems();
            int i = 0;
            while (i < items.length) {
                if (!"".equals(items[i])) {
                    Point extent = TextSizeDetermination.stringExtent(this.getFont(), items[i]);
                    width = Math.max(width, extent.x + 10);
                }
                ++i;
            }
        }
        Rectangle padding = this.getPadding();
        if (width != 0) {
            width += padding.width + 14;
        }
        if (height != 0) {
            height += padding.height;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += 2 * border, height += 2 * border);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.addListener(this, listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.removeListener(this, listener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        VerifyEvent.addListener(this, verifyListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        VerifyEvent.removeListener(this, verifyListener);
    }

    boolean isTabGroup() {
        return true;
    }

    String getNameText() {
        return this.getText();
    }

    private String verifyText(String text, int start, int end) {
        VerifyEvent event = new VerifyEvent(this);
        event.text = text;
        event.start = start;
        event.end = end;
        event.processEvent();
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        String result = event.text;
        return result;
    }

    private void updateText() {
        if ((this.style & 8) == 0) {
            int selectionIndex = this.getSelectionIndex();
            if (selectionIndex != -1) {
                this.setText(this.getItem(selectionIndex));
            } else {
                this.setText("");
            }
        } else {
            this.fireModifyEvent();
        }
    }

    private void fireModifyEvent() {
        ModifyEvent modifyEvent = new ModifyEvent(this);
        modifyEvent.processEvent();
    }

    private Rectangle getPadding() {
        ThemeManager manager = ThemeManager.getInstance();
        ComboThemeAdapter adapter = (ComboThemeAdapter)manager.getThemeAdapter(this.getClass());
        return adapter.getPadding(this);
    }

    private static int checkStyle(int style) {
        int result = style;
        result &= 0xFFFFF7FF;
        result &= 0xFFFFFCFF;
        if (((result = Combo.checkBits(result, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return result & 0xFFFFFFF7;
        }
        return result |= 0x100;
    }
}

